/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl.job;

import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.platform.groups.audit.service.acl.job.ITimeoutable;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class Work
extends AbstractWork
implements ITimeoutable {
    public static final String PROPERTY_ACL_AUDIT_TIMEOUT = "nuxeo.audit.acl.timeout";
    public static final int DEFAULT_TIMEOUT = 1200;
    public static final int UNDEFINED_TIMEOUT = -1;
    protected Runnable runnable;
    protected String name;
    protected int timeout;

    public Work(String name) {
        this(null, name, Work.getAclAuditTimeoutFromProperties());
    }

    public Work(String name, int timeout) {
        this(null, name, timeout);
    }

    public Work(Runnable runnable, String name) {
        this(runnable, name, Work.getAclAuditTimeoutFromProperties());
    }

    public Work(Runnable runnable, String name, int timeout) {
        this.runnable = runnable;
        this.name = name;
        this.timeout = timeout;
        if (this.timeout == -1) {
            this.timeout = 1200;
        }
    }

    public String getTitle() {
        return this.name;
    }

    public void work() throws Exception {
        this.setProgress(Work.Progress.PROGRESS_0_PC);
        this.runnable.run();
        this.setProgress(Work.Progress.PROGRESS_100_PC);
    }

    protected boolean startTransaction() {
        if (this.isTransactional() && !this.isTransactionStarted) {
            this.isTransactionStarted = TransactionHelper.startTransaction((int)this.getTimeout());
        }
        return this.isTransactionStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.state == Work.State.SUSPENDED) {
            return;
        }
        boolean tx = this.isTransactional();
        if (tx) {
            this.isTransactionStarted = TransactionHelper.startTransaction((int)this.getTimeout());
        }
        boolean ok = false;
        Exception err = null;
        try {
            this.work();
            ok = true;
        }
        catch (Exception e) {
            err = e;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.cleanUp(ok, err);
            }
            finally {
                try {
                    if (tx && this.isTransactionStarted) {
                        if (!ok) {
                            TransactionHelper.setTransactionRollbackOnly();
                        }
                        TransactionHelper.commitOrRollbackTransaction();
                        this.isTransactionStarted = false;
                    }
                }
                finally {
                    if (err instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public static int getAclAuditTimeoutFromProperties() {
        String v = Framework.getProperty((String)PROPERTY_ACL_AUDIT_TIMEOUT, (String)"-1");
        try {
            return Integer.parseInt(v);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

