/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Sheet;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.groups.audit.service.acl.IAclExcelLayoutBuilder;
import org.nuxeo.ecm.platform.groups.audit.service.acl.Pair;
import org.nuxeo.ecm.platform.groups.audit.service.acl.ReportLayout;
import org.nuxeo.ecm.platform.groups.audit.service.acl.ReportLayoutSettings;
import org.nuxeo.ecm.platform.groups.audit.service.acl.data.DataProcessor;
import org.nuxeo.ecm.platform.groups.audit.service.acl.data.DataProcessorPaginated;
import org.nuxeo.ecm.platform.groups.audit.service.acl.data.DocumentSummary;
import org.nuxeo.ecm.platform.groups.audit.service.acl.data.IDataProcessor;
import org.nuxeo.ecm.platform.groups.audit.service.acl.excel.AclNameShortner;
import org.nuxeo.ecm.platform.groups.audit.service.acl.excel.ByteColor;
import org.nuxeo.ecm.platform.groups.audit.service.acl.excel.ExcelBuilder;
import org.nuxeo.ecm.platform.groups.audit.service.acl.excel.ExcelBuilderMultiSheet;
import org.nuxeo.ecm.platform.groups.audit.service.acl.excel.IExcelBuilder;
import org.nuxeo.ecm.platform.groups.audit.service.acl.filter.AcceptsAllContent;
import org.nuxeo.ecm.platform.groups.audit.service.acl.filter.IContentFilter;
import org.nuxeo.ecm.platform.groups.audit.service.acl.utils.MessageAccessor;

public class AclExcelLayoutBuilder
implements IAclExcelLayoutBuilder {
    protected static Log log = LogFactory.getLog(AclExcelLayoutBuilder.class);
    protected static final String PROPERTY_MAIN_SHEET_NAME = "message.acl.audit.xl.mainsheet";
    protected static final String PROPERTY_LEGEND_SHEET_NAME = "message.acl.audit.xl.legend";
    protected static final String PROPERTY_LEGEND_LOCK_INHERITANCE = "message.acl.audit.xl.legend.lockInheritance";
    protected static final String PROPERTY_LEGEND_PERM_DENIED = "message.acl.audit.xl.legend.denied";
    protected IExcelBuilder excel = new ExcelBuilder();
    protected static int CELL_WIDTH_UNIT = 256;
    public static int STATUS_ROW = 0;
    public static int STATUS_COL = 0;
    protected ReportLayoutSettings layoutSettings;
    protected ReportLayout layout;
    protected int treeLineCursor = 0;
    protected CellStyle userHeaderStyle;
    protected CellStyle aclHeaderStyle;
    protected CellStyle lockInheritanceStyle;
    protected CellStyle grayTextStyle;
    protected int mainSheetId;
    protected int legendSheetId;
    protected String mainSheetName;
    protected String legendSheetName;
    protected String legendLockInheritance = "Permission inheritance locked";
    protected String legendPermissionDenied = "Permission denied";
    protected IContentFilter filter;
    protected AclNameShortner shortner;
    protected IDataProcessor data;

    public static ReportLayoutSettings defaultLayout() {
        ReportLayoutSettings layout = new ReportLayoutSettings();
        layout.userHeaderHeight = 1000;
        layout.userHeaderRotation = 45;
        layout.fileTreeColumnWidth = 2.0;
        layout.aclColumnWidth = 4.0;
        layout.defaultRowHeight = 100;
        layout.splitPaneX = 500;
        layout.splitPaneY = 1500;
        layout.freezePaneRowSplit = 1;
        layout.treeLineCursorRowStart = 1;
        layout.spanMode = ReportLayoutSettings.SpanMode.COLUMN_OVERFLOW_ON_NEXT_SHEETS;
        layout.zoomRatioDenominator = 2;
        layout.zoomRatioNumerator = 1;
        layout.showFullPath = false;
        layout.pageSize = 1000;
        return layout;
    }

    public AclExcelLayoutBuilder() {
        this(AclExcelLayoutBuilder.defaultLayout());
    }

    public AclExcelLayoutBuilder(IContentFilter filter) {
        this(AclExcelLayoutBuilder.defaultLayout(), filter);
    }

    public AclExcelLayoutBuilder(ReportLayoutSettings layout) {
        this(layout, null);
    }

    public AclExcelLayoutBuilder(ReportLayoutSettings layout, IContentFilter filter) {
        this.layoutSettings = layout;
        if (ReportLayoutSettings.SpanMode.NONE.equals((Object)layout.spanMode)) {
            this.excel = new ExcelBuilder(ExcelBuilder.Type.XLS, "Permissions");
        } else if (ReportLayoutSettings.SpanMode.COLUMN_OVERFLOW_ON_NEXT_SHEETS.equals((Object)layout.spanMode)) {
            this.excel = new ExcelBuilderMultiSheet(ExcelBuilder.Type.XLS, "Permissions");
            ((ExcelBuilderMultiSheet)this.excel).setMultiSheetColumns(true);
        } else {
            throw new IllegalArgumentException("layout span mode unknown: " + (Object)((Object)layout.spanMode));
        }
        this.filter = filter == null ? new AcceptsAllContent() : filter;
        this.data = this.layoutSettings.pageSize > 0 ? new DataProcessorPaginated(this.filter, this.layoutSettings.pageSize) : new DataProcessor(this.filter);
        this.shortner = new AclNameShortner();
        this.layout = new ReportLayout();
    }

    @Override
    public void renderAudit(CoreSession session) throws ClientException {
        this.renderAudit(session, session.getRootDocument(), true);
    }

    @Override
    public void renderAudit(CoreSession session, DocumentModel doc) throws ClientException {
        this.renderAudit(session, doc, true);
    }

    @Override
    public void renderAudit(CoreSession session, DocumentModel doc, boolean unrestricted) throws ClientException {
        this.renderAudit(session, doc, unrestricted, 0);
    }

    @Override
    public void renderAudit(CoreSession session, final DocumentModel doc, boolean unrestricted, final int timeout) throws ClientException {
        if (!unrestricted) {
            this.analyzeAndRender(session, doc, timeout);
        } else {
            UnrestrictedSessionRunner runner = new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    AclExcelLayoutBuilder.this.analyzeAndRender(this.session, doc, timeout);
                }
            };
            runner.runUnrestricted();
        }
    }

    protected void analyzeAndRender(CoreSession session, DocumentModel doc, int timeout) throws ClientException {
        log.debug((Object)"start processing data");
        this.data.analyze(session, doc, timeout);
        this.configure(session);
        this.render(this.data);
    }

    protected void configure(CoreSession session) throws ClientException {
        this.legendSheetName = MessageAccessor.get(session, PROPERTY_LEGEND_SHEET_NAME);
        this.legendLockInheritance = MessageAccessor.get(session, PROPERTY_LEGEND_LOCK_INHERITANCE);
        this.legendPermissionDenied = MessageAccessor.get(session, PROPERTY_LEGEND_PERM_DENIED);
    }

    protected void render(IDataProcessor data) throws ClientException {
        int minDepth = data.getDocumentTreeMinDepth();
        int maxDepth = data.getDocumentTreeMaxDepth();
        int colStart = maxDepth + (this.layoutSettings.showFullPath ? 1 : 0);
        this.mainSheetId = this.excel.getCurrentSheetId();
        this.legendSheetId = this.excel.newSheet(this.excel.getCurrentSheetId() + 1, this.legendSheetName);
        this.renderInit();
        this.renderHeader(colStart, data.getUserAndGroups(), data.getPermissions());
        this.renderFileTreeAndAclMatrix(data.getAllDocuments(), minDepth, maxDepth);
        this.formatFileTreeCellLayout(maxDepth, minDepth, colStart);
        this.renderLegend(data.getStatus(), data.getInformation());
        this.renderFinal();
    }

    protected void renderInit() {
        this.layout.reset();
        this.userHeaderStyle = this.excel.newCellStyle();
        this.userHeaderStyle.setFont(this.excel.getBoldFont());
        this.userHeaderStyle.setAlignment((short)2);
        if (this.layoutSettings.userHeaderRotation != 0) {
            this.userHeaderStyle.setRotation((short)this.layoutSettings.userHeaderRotation);
        }
        this.aclHeaderStyle = this.excel.newCellStyle();
        this.aclHeaderStyle.setFont(this.excel.newFont(this.layoutSettings.aclHeaderFontSize));
        this.aclHeaderStyle.setAlignment((short)2);
        if (this.layoutSettings.aclHeaderRotation != 0) {
            this.aclHeaderStyle.setRotation((short)this.layoutSettings.aclHeaderRotation);
        }
        this.lockInheritanceStyle = this.excel.newColoredCellStyle(ByteColor.BLUE);
        this.grayTextStyle = this.excel.newCellStyle();
        Font f = this.excel.newFont();
        f.setColor((short)23);
        this.grayTextStyle.setFont(f);
    }

    protected void renderFinal() {
        for (Sheet s : this.excel.getAllSheets()) {
            s.setZoom(this.layoutSettings.zoomRatioNumerator, this.layoutSettings.zoomRatioDenominator);
        }
    }

    protected void renderHeader(int tableStartColumn, Set<String> userOrGroups, Set<String> permission) {
        this.renderHeaderUsers(tableStartColumn, userOrGroups);
    }

    protected void renderHeaderUsers(int tableStartColumn, Set<String> userOrGroups) {
        int column = tableStartColumn;
        for (String userOrGroup : userOrGroups) {
            this.excel.setCell(0, column, userOrGroup, this.userHeaderStyle);
            this.layout.setUserColumn(column, userOrGroup);
            ++column;
        }
        this.excel.setRowHeight(0, this.layoutSettings.userHeaderHeight);
    }

    protected void renderFileTreeAndAclMatrix(Collection<DocumentSummary> analyses, int minDepth, int maxDepth) throws ClientException {
        this.treeLineCursor = this.layoutSettings.treeLineCursorRowStart;
        for (DocumentSummary summary : analyses) {
            this.renderFilename(summary.getTitle(), summary.getDepth() - minDepth, summary.isAclLockInheritance());
            if (this.layoutSettings.showFullPath) {
                this.excel.setCell(this.treeLineCursor, maxDepth - minDepth + 1, summary.getPath());
            }
            if (summary.getAclInheritedByUser() != null) {
                this.renderAcl(summary.getAclByUser(), summary.getAclInheritedByUser());
            } else {
                this.renderAcl(summary.getAclByUser());
            }
            ++this.treeLineCursor;
        }
    }

    protected void renderFilename(String title, int depth, boolean lockInheritance) throws ClientException {
        this.excel.setCell(this.treeLineCursor, depth, title);
        if (depth > 0 && lockInheritance) {
            this.excel.setCell(this.treeLineCursor, depth - 1, "", this.lockInheritanceStyle);
        }
    }

    protected void renderAcl(Multimap<String, Pair<String, Boolean>> userAcls) throws ClientException {
        this.renderAcl(userAcls, (CellStyle)null);
    }

    protected void renderAcl(Multimap<String, Pair<String, Boolean>> userAcls, CellStyle style) throws ClientException {
        for (String user : userAcls.keySet()) {
            int column = this.layout.getUserColumn(user);
            String info = this.formatAcl(userAcls.get((Object)user));
            this.excel.setCell(this.treeLineCursor, column, info, style);
        }
    }

    protected void renderAcl(Multimap<String, Pair<String, Boolean>> localAcls, Multimap<String, Pair<String, Boolean>> inheritedAcls) throws ClientException {
        HashSet users = new HashSet();
        users.addAll(localAcls.keySet());
        users.addAll(inheritedAcls.keySet());
        for (String user : users) {
            String info;
            int column = this.layout.getUserColumn(user);
            String localAclsString = this.formatAcl(localAcls.get((Object)user));
            String inheritedAclsString = this.formatAcl(inheritedAcls.get((Object)user));
            if ("".equals(localAclsString) && "".equals(inheritedAclsString)) continue;
            if (!"".equals(localAclsString) && !"".equals(inheritedAclsString)) {
                info = localAclsString + "," + inheritedAclsString;
                this.excel.setCell(this.treeLineCursor, column, info);
                continue;
            }
            if (!"".equals(localAclsString) && "".equals(inheritedAclsString)) {
                info = localAclsString;
                this.excel.setCell(this.treeLineCursor, column, info);
                continue;
            }
            if (!"".equals(localAclsString) || "".equals(inheritedAclsString)) continue;
            info = inheritedAclsString;
            this.excel.setCell(this.treeLineCursor, column, info, this.grayTextStyle);
        }
    }

    protected void renderLegend(DataProcessor.ProcessorStatus status, String message) {
        ((ExcelBuilderMultiSheet)this.excel).setMultiSheetColumns(false);
        this.excel.setCurrentSheetId(this.legendSheetId);
        int row = STATUS_ROW;
        int col = STATUS_COL;
        int off = this.renderLegendErrorMessage(row, col, status, message);
        off = this.renderLegendAcl(off + 1, 0);
        this.excel.setCell(++off, col, "", this.lockInheritanceStyle);
        this.excel.setCell(off, col + 1, this.legendLockInheritance);
        ++off;
    }

    protected int renderLegendErrorMessage(int row, int col, DataProcessor.ProcessorStatus status, String message) {
        if (!DataProcessor.ProcessorStatus.SUCCESS.equals((Object)status)) {
            this.excel.setCell(row++, col, "Status: " + (Object)((Object)status));
            if (message != null && !"".equals(message)) {
                this.excel.setCell(row++, col, "Message: " + message);
            }
        }
        return row;
    }

    protected int renderLegendAcl(int row, int col) {
        this.excel.setCell(row++, col, "ACL meaning");
        for (String shortName : this.shortner.getShortNames()) {
            String fullName = this.shortner.getFullName(shortName);
            this.excel.setCell(row, col, shortName);
            this.excel.setCell(row, col + 1, fullName);
            ++row;
        }
        return row;
    }

    protected String formatAcl(Collection<Pair<String, Boolean>> acls) {
        StringBuilder sb = new StringBuilder();
        int k = 0;
        for (Pair<String, Boolean> ace : acls) {
            sb.append(this.formatAce(ace));
            if (++k >= acls.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected String formatAce(Pair<String, Boolean> ace) {
        if (((Boolean)ace.b).booleanValue()) {
            return this.formatPermission((String)ace.a);
        }
        return "!" + this.formatPermission((String)ace.a);
    }

    protected String formatPermission(String permission) {
        return this.shortner.getShortName(permission);
    }

    protected void formatFileTreeCellLayout(int maxDepth, int minDepth, int colStart) {
        int realMax = maxDepth - minDepth;
        for (int i = 0; i < realMax; ++i) {
            this.excel.setColumnWidth(i, (int)(this.layoutSettings.fileTreeColumnWidth * (double)CELL_WIDTH_UNIT));
        }
        this.excel.setColumnWidthAuto(realMax);
        this.excel.setFreezePane(colStart, this.layoutSettings.freezePaneRowSplit);
    }

    @Override
    public IExcelBuilder getExcel() {
        return this.excel;
    }
}

