/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.imaging.recompute;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;

public class ImagingRecomputeWork
extends AbstractWork {
    protected static final int BATCH_SIZE = 10;
    protected String repositoryName;
    protected String nxqlQuery;

    public ImagingRecomputeWork(String repositoryName, String nxqlQuery) {
        this.repositoryName = repositoryName;
        this.nxqlQuery = nxqlQuery;
    }

    public String getTitle() {
        return "Picture Views Recomputation";
    }

    public void work() {
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.openSystemSession();
        DocumentModelList docs = this.session.query(this.nxqlQuery);
        long docsUpdated = 0L;
        this.setStatus("Generating views");
        for (DocumentModel doc : docs) {
            BlobHolder blobHolder;
            if (!doc.hasFacet("Picture") || (blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class)).getBlob() == null) continue;
            blobHolder.setBlob(blobHolder.getBlob());
            this.session.saveDocument(doc);
            if (++docsUpdated % 10L != 0L) continue;
            this.commitOrRollbackTransaction();
            this.startTransaction();
        }
        this.setStatus("Done");
    }
}

