/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.mail;

import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.mail.Session;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.mail.MailSessionBuilder;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LogCaptureFeature;
import org.nuxeo.runtime.test.runner.LogFeature;
import org.nuxeo.runtime.test.runner.LoggerLevel;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.WithFrameworkProperty;

@LoggerLevel(klass=Session.class, level="DEBUG")
@LogCaptureFeature.FilterOn(loggerClass=Session.class, logLevel="DEBUG")
@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeFeature.class, LogFeature.class, LogCaptureFeature.class})
public class TestMailSessionBuilder {
    @Inject
    protected LogCaptureFeature.Result logCaptureResult;

    @Test
    public void testBuildFromProperties() {
        Session session = MailSessionBuilder.fromProperties((Properties)new Properties()).build();
        Assert.assertNotNull((Object)session);
        Assert.assertTrue((boolean)this.logCaptureResult.getCaughtEventMessages().isEmpty());
    }

    @Test
    public void testBuildFromPropertiesWithProgrammaticDebug() {
        Session session = ((MailSessionBuilder.FromProperties)MailSessionBuilder.fromProperties((Properties)new Properties()).debug()).build();
        Assert.assertNotNull((Object)session);
        this.logCaptureResult.assertHasEvent();
        List logs = this.logCaptureResult.getCaughtEventMessages();
        Assert.assertEquals((long)1L, (long)logs.size());
        String log = (String)logs.get(0);
        Assert.assertTrue((String)log, (boolean)log.startsWith("setDebug: JavaMail version "));
    }

    @Test
    @WithFrameworkProperty(name="mail.debug", value="true")
    public void testBuildFromPropertiesWithFrameworkDebug() {
        Session session = MailSessionBuilder.fromProperties((Properties)new Properties()).build();
        Assert.assertNotNull((Object)session);
        this.logCaptureResult.assertHasEvent();
        List logs = this.logCaptureResult.getCaughtEventMessages();
        String log = (String)logs.get(0);
        Assert.assertTrue((String)log, (boolean)log.startsWith("setDebug: JavaMail version "));
    }
}

