/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.mail;

import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.mail.MailSessionBuilder;
import org.nuxeo.mail.SmtpMailServerFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={SmtpMailServerFeature.class})
public class TestSmtpMailServerFeature {
    @Inject
    protected SmtpMailServerFeature.MailsResult result;

    @Test
    public void testFeature() throws MessagingException {
        Session session = MailSessionBuilder.fromNuxeoConf().build();
        MimeMessage message = new MimeMessage(session);
        message.addRecipients(Message.RecipientType.TO, "someone@nuxeo.com");
        message.setText("Some content");
        Transport.send((Message)message);
        Assert.assertEquals((long)1L, (long)this.result.getSize());
    }

    @Test
    public void testFeatureResultIsolation() throws MessagingException {
        this.testFeature();
    }
}

