/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.permissions;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class PermissionHelper {
    private PermissionHelper() {
    }

    public static String computeDirectoryId(DocumentModel doc, String aclName, String aceId) {
        return String.format("%s:%s:%s:%s", doc.getId(), doc.getRepositoryName(), aclName, aceId);
    }

    public static Map<String, Object> createDirectoryEntry(DocumentModel doc, String aclName, ACE ace, boolean notify, String comment) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("aceinfo:id", PermissionHelper.computeDirectoryId(doc, aclName, ace.getId()));
        m.put("aceinfo:repositoryName", doc.getRepositoryName());
        m.put("aceinfo:docId", doc.getId());
        m.put("aceinfo:aclName", aclName);
        m.put("aceinfo:aceId", ace.getId());
        m.put("aceinfo:notify", notify);
        m.put("aceinfo:comment", comment);
        return m;
    }

    public static void firePermissionNotificationEvent(CoreSession session, DocumentModel doc, String aclName, ACE ace) {
        DocumentEventContext docCtx = new DocumentEventContext(session, session.getPrincipal(), doc);
        docCtx.setProperty("ace", (Serializable)ace);
        docCtx.setProperty("aclName", (Serializable)((Object)aclName));
        EventService eventService = (EventService)Framework.getService(EventService.class);
        eventService.fireEvent("permissionNotification", (EventContext)docCtx);
    }
}

