/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.permissions;

import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class TransientUserPermissionHelper {
    public static final String OTHER_DOCUMENT_WITH_PENDING_OR_EFFECTIVE_ACL_QUERY = "SELECT ecm:uuid FROM Document, Relation WHERE (ecm:acl/*1/status is NULL OR ecm:acl/*1/status = 0 OR ecm:acl/*1/status = 1) AND ecm:acl/*1/principal = %s AND ecm:uuid <> %s";
    public static final String TRANSIENT_APP_NAME = "transient/appName";
    public static final String TRANSIENT_DEVICE_ID = "transient/deviceId";
    public static final String TRANSIENT_PERMISSION = "transient/permission";

    private TransientUserPermissionHelper() {
    }

    @Deprecated
    public static String acquireToken(String username, DocumentModel doc, String permission) {
        TransientUserPermissionHelper.addToken(username);
        return null;
    }

    public static void addToken(String username) {
        if (NuxeoPrincipal.isTransientUsername((String)username)) {
            TokenAuthenticationService tokenAuthenticationService = (TokenAuthenticationService)Framework.getService(TokenAuthenticationService.class);
            tokenAuthenticationService.acquireToken(username, TRANSIENT_APP_NAME, TRANSIENT_DEVICE_ID, null, TRANSIENT_PERMISSION);
        }
    }

    public static String getToken(String username) {
        return ((TokenAuthenticationService)Framework.getService(TokenAuthenticationService.class)).getToken(username, TRANSIENT_APP_NAME, TRANSIENT_DEVICE_ID);
    }

    public static void revokeToken(String username, DocumentModel doc) {
        if (NuxeoPrincipal.isTransientUsername((String)username)) {
            if (TransientUserPermissionHelper.hasOtherPermission(username, doc)) {
                return;
            }
            ACP acp = doc.getACP();
            for (ACL acl : acp.getACLs()) {
                if ("inherited".equals(acl.getName())) continue;
                for (ACE ace : acl) {
                    if (!username.equals(ace.getUsername()) || ace.isArchived()) continue;
                    return;
                }
            }
            TokenAuthenticationService tokenAuthenticationService = (TokenAuthenticationService)Framework.getService(TokenAuthenticationService.class);
            String token = tokenAuthenticationService.getToken(username, TRANSIENT_APP_NAME, TRANSIENT_DEVICE_ID);
            if (token != null) {
                tokenAuthenticationService.revokeToken(token);
            }
            if ((token = tokenAuthenticationService.getToken(username, doc.getRepositoryName(), doc.getId())) != null) {
                tokenAuthenticationService.revokeToken(token);
            }
        }
    }

    protected static boolean hasOtherPermission(String username, DocumentModel doc) {
        if (((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanPropertyTrue("nuxeo.transient.username.unique")) {
            return false;
        }
        String query = String.format(OTHER_DOCUMENT_WITH_PENDING_OR_EFFECTIVE_ACL_QUERY, NXQL.escapeString((String)username), NXQL.escapeString((String)doc.getId()));
        return (Boolean)CoreInstance.doPrivileged((String)doc.getRepositoryName(), session -> !session.queryProjection(query, 1L, 0L).isEmpty());
    }
}

