/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.permissions.operations;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.permissions.PermissionHelper;

@Operation(id="Document.SendNotificationEmailForPermission", category="Document", label="Send the notification email for a permission", description="Send the notification email for a permission on the input document(s). Returns the document(s).")
public class SendNotificationEmailForPermission {
    public static final String ID = "Document.SendNotificationEmailForPermission";
    @Context
    protected CoreSession session;
    @Param(name="id", description="ACE id.")
    String id;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        this.sendEmail(doc);
        return this.session.getDocument(doc.getRef());
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef docRef) {
        DocumentModel doc = this.session.getDocument(docRef);
        this.sendEmail(doc);
        return doc;
    }

    protected void sendEmail(DocumentModel doc) {
        ACE ace = ACE.fromId((String)this.id);
        String aclName = null;
        ACP acp = doc.getACP();
        for (ACL acl : acp.getACLs()) {
            if (!acl.contains((Object)ace)) continue;
            aclName = acl.getName();
            break;
        }
        if (aclName == null) {
            return;
        }
        PermissionHelper.firePermissionNotificationEvent(this.session, doc, aclName, ace);
    }
}

