/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.count;

import java.io.Serializable;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.quota.QuotaStatsService;
import org.nuxeo.ecm.quota.QuotaStatsUpdater;
import org.nuxeo.runtime.api.Framework;

@Name(value="quotaStatsActions")
@Scope(value=ScopeType.STATELESS)
@Install(precedence=10)
public class QuotaStatsActions
implements Serializable {
    private static final long serialVersionUID = -1L;
    @In(create=true)
    protected transient CoreSession documentManager;

    public List<QuotaStatsUpdater> getQuotaStatsUpdaters() {
        QuotaStatsService quotaStatsService = (QuotaStatsService)Framework.getLocalService(QuotaStatsService.class);
        return quotaStatsService.getQuotaStatsUpdaters();
    }

    public void launchInitialComputation(String updaterName) {
        this.launchInitialComputation(updaterName, this.documentManager.getRepositoryName());
    }

    public void launchInitialComputation(String updaterName, String repositoryName) {
        QuotaStatsService quotaStatsService = (QuotaStatsService)Framework.getLocalService(QuotaStatsService.class);
        quotaStatsService.launchInitialStatisticsComputation(updaterName, repositoryName);
    }

    public String getStatus(String updaterName) {
        QuotaStatsService quotaStatsService = (QuotaStatsService)Framework.getLocalService(QuotaStatsService.class);
        return quotaStatsService.getProgressStatus(updaterName);
    }
}

