/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.count;

import java.io.Serializable;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.quota.QuotaStatsService;
import org.nuxeo.ecm.quota.QuotaStatsUpdater;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaAwareDocument;
import org.nuxeo.ecm.quota.size.QuotaAwareDocumentFactory;
import org.nuxeo.ecm.quota.size.QuotaDisplayValue;
import org.nuxeo.runtime.api.Framework;

@Name(value="quotaStatsActions")
@Scope(value=ScopeType.STATELESS)
@Install(precedence=10)
public class QuotaStatsActions
implements Serializable {
    private static final long serialVersionUID = -1L;
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;

    public List<QuotaStatsUpdater> getQuotaStatsUpdaters() {
        QuotaStatsService quotaStatsService = (QuotaStatsService)Framework.getLocalService(QuotaStatsService.class);
        return quotaStatsService.getQuotaStatsUpdaters();
    }

    public void launchInitialComputation(String updaterName) {
        this.launchInitialComputation(updaterName, this.documentManager.getRepositoryName());
    }

    public void launchInitialComputation(String updaterName, String repositoryName) {
        QuotaStatsService quotaStatsService = (QuotaStatsService)Framework.getLocalService(QuotaStatsService.class);
        quotaStatsService.launchInitialStatisticsComputation(updaterName, repositoryName);
    }

    public String getStatus(String updaterName) {
        QuotaStatsService quotaStatsService = (QuotaStatsService)Framework.getLocalService(QuotaStatsService.class);
        return quotaStatsService.getProgressStatus(updaterName);
    }

    @Factory(value="currentQuotaDoc", scope=ScopeType.EVENT)
    public QuotaAware getQuotaDoc() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        return (QuotaAware)doc.getAdapter(QuotaAware.class);
    }

    public void activateQuota() throws ClientException {
        if (this.getQuotaDoc() == null) {
            DocumentModel doc = this.navigationContext.getCurrentDocument();
            QuotaAwareDocument qa = QuotaAwareDocumentFactory.make((DocumentModel)doc, (boolean)true);
            this.navigationContext.resetCurrentContext();
            this.navigationContext.navigateToDocument(qa.getDoc());
        }
    }

    public void validateQuotaSize(FacesContext context, UIComponent component, Object value) {
        String strValue = value.toString();
        try {
            Long quotaValue = Long.parseLong(strValue);
        }
        catch (NumberFormatException e) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"wrong format"), null);
            context.addMessage(null, message);
            throw new ValidatorException(message);
        }
    }

    public QuotaDisplayValue formatQuota(long value, long max) {
        QuotaDisplayValue qdv = new QuotaDisplayValue(value, max);
        return qdv;
    }

    public double getMinQuotaSliderValue(long totalSize) throws Exception {
        long minSize = 102400L;
        if (totalSize > minSize) {
            return Math.log(totalSize + minSize);
        }
        return Math.log(minSize);
    }
}

