/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.adapters;

import java.io.Serializable;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.restapi.server.jaxrs.adapters.PaginableAdapter;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="audit", type="AuditService")
@Produces(value={"application/json+nxentity", "application/json"})
public class AuditAdapter
extends PaginableAdapter<LogEntry> {
    public static final String NAME = "audit";
    public static final String PAGE_PROVIDER_NAME = "DOCUMENT_HISTORY_PROVIDER";
    public static final String EVENT_ID_PARAMETER_NAME = "eventId";
    public static final String CATEGORY_PARAMETER_NAME = "category";
    public static final String PRINCIPAL_NAME_PARAMETER_NAME = "principalName";
    public static final String START_EVENT_DATE_PARAMETER_NAME = "startEventDate";
    public static final String END_EVENT_DATE_PARAMETER_NAME = "endEventDate";

    @Override
    protected PageProviderDefinition getPageProviderDefinition() {
        PageProviderService ppService = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        return ppService.getPageProviderDefinition(PAGE_PROVIDER_NAME);
    }

    @Override
    protected Object[] getParams() {
        return new Object[]{this.getTarget().getAdapter(DocumentModel.class)};
    }

    @Override
    protected DocumentModel getSearchDocument() throws ClientException {
        HttpServletRequest request = this.ctx.getRequest();
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel searchDocument = session.createDocumentModel("BasicAuditSearch");
        searchDocument.setPropertyValue("bas:eventIds", (Serializable)request.getParameterValues(EVENT_ID_PARAMETER_NAME));
        searchDocument.setPropertyValue("bas:eventCategories", (Serializable)request.getParameterValues(CATEGORY_PARAMETER_NAME));
        searchDocument.setPropertyValue("bas:principalNames", (Serializable)request.getParameterValues(PRINCIPAL_NAME_PARAMETER_NAME));
        searchDocument.setPropertyValue("bas:startDate", (Serializable)this.getCalendarParameter(request, START_EVENT_DATE_PARAMETER_NAME));
        searchDocument.setPropertyValue("bas:endDate", (Serializable)this.getCalendarParameter(request, END_EVENT_DATE_PARAMETER_NAME));
        return searchDocument;
    }

    protected Calendar getCalendarParameter(HttpServletRequest request, String paramName) {
        DateTime date;
        String param = request.getParameter(paramName);
        if (param != null && (date = ISODateTimeFormat.date().parseDateTime(param)) != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date.toDate());
            return cal;
        }
        return null;
    }
}

