/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs;

import com.unboundid.scim.data.AuthenticationScheme;
import com.unboundid.scim.data.BulkConfig;
import com.unboundid.scim.data.ChangePasswordConfig;
import com.unboundid.scim.data.FilterConfig;
import com.unboundid.scim.data.PatchConfig;
import com.unboundid.scim.data.ServiceProviderConfig;
import com.unboundid.scim.data.SortConfig;
import com.unboundid.scim.data.XmlDataFormatConfig;
import com.unboundid.scim.schema.CoreSchema;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.webengine.model.Template;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;

@Path(value="/scim/v1")
@Produces(value={"text/html;charset=UTF-8"})
@WebObject(type="SCIMRoot")
public class SCIMRoot
extends ModuleRoot {
    @Path(value="/Users")
    public Object doGetUsersResource() {
        return this.newObject("users", new Object[0]);
    }

    @Path(value="/Users.json")
    public Object doGetUsersJsonResource() {
        return this.newObject("users", new Object[]{MediaType.APPLICATION_JSON_TYPE});
    }

    @Path(value="/Users.xml")
    public Object doGetUsersXmlResource() {
        return this.newObject("users", new Object[]{MediaType.APPLICATION_XML_TYPE});
    }

    @Path(value="/Groups")
    public Object doGetGroups() {
        return this.newObject("groups", new Object[0]);
    }

    @Path(value="/Groups.json")
    public Object doGetGroupsAsJson() {
        return this.newObject("groups", new Object[]{MediaType.APPLICATION_JSON_TYPE});
    }

    @Path(value="/Groups.xml")
    public Object doGetGroupsAsJXml() {
        return this.newObject("groups", new Object[]{MediaType.APPLICATION_XML_TYPE});
    }

    protected Object getSchema(String schemaName, String format) {
        String viewName = "user-schema";
        if (schemaName.equalsIgnoreCase("users")) {
            viewName = "user-schema";
        } else if (schemaName.equalsIgnoreCase("groups")) {
            viewName = "group-schema";
        }
        Template tmpl = this.getView(viewName + "." + format);
        return tmpl;
    }

    @GET
    @Path(value="/Schemas/{schemaName}")
    @Produces(value={"application/json", "application/xml; qs=0.9"})
    public Object getSchema(@PathParam(value="schemaName") String schemaName, @Context HttpHeaders headers) {
        List accepted = headers.getRequestHeader("Accept");
        if (accepted.contains("application/json")) {
            return this.getSchema(schemaName, "json");
        }
        return this.getSchema(schemaName, "xml");
    }

    @GET
    @Path(value="/Schemas/{schemaName}.json")
    @Produces(value={"application/json"})
    public Object getSchemaAsJson(@PathParam(value="schemaName") String schemaName) {
        return this.getSchema(schemaName, "json");
    }

    @GET
    @Path(value="/Schemas/{schemaName}.xml")
    @Produces(value={"application/xml"})
    public Object getSchemaAsXml(@PathParam(value="schemaName") String schemaName) {
        return this.getSchema(schemaName, "xml");
    }

    @GET
    @Path(value="/ServiceProviderConfigs")
    @Produces(value={"application/json", "application/xml; qs=0.9"})
    public ServiceProviderConfig getConfig() {
        ServiceProviderConfig config = new ServiceProviderConfig(CoreSchema.SERVICE_PROVIDER_CONFIG_SCHEMA_DESCRIPTOR);
        config.setId("Nuxeo");
        config.setExternalId("Nuxeo");
        ArrayList<AuthenticationScheme> authSchemes = new ArrayList<AuthenticationScheme>();
        authSchemes.add(AuthenticationScheme.createBasic((boolean)true));
        config.setAuthenticationSchemes(authSchemes);
        FilterConfig filterConfig = new FilterConfig(true, 1000L);
        config.setFilterConfig(filterConfig);
        BulkConfig bulkConfig = new BulkConfig(false, 0L, 0L);
        config.setBulkConfig(bulkConfig);
        ChangePasswordConfig changePasswordConfig = new ChangePasswordConfig(false);
        config.setChangePasswordConfig(changePasswordConfig);
        config.setPatchConfig(new PatchConfig(false));
        config.setSortConfig(new SortConfig(true));
        config.setXmlDataFormatConfig(new XmlDataFormatConfig(true));
        return config;
    }

    public Object handleError(WebApplicationException e) {
        if (e instanceof WebSecurityException) {
            return Response.status((int)401).entity((Object)"not authorized").type("text/plain").build();
        }
        if (e instanceof WebResourceNotFoundException) {
            return Response.status((int)404).entity((Object)e.getMessage()).type("text/plain").build();
        }
        return super.handleError(e);
    }
}

