/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.marshalling;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.marshal.json.JsonUnmarshaller;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.StaticUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.scim.server.jaxrs.marshalling.NXJsonParser;

public class NXJsonUnmarshaller
extends JsonUnmarshaller {
    public <R extends BaseResource> R unmarshal(InputStream inputStream, ResourceDescriptor resourceDescriptor, ResourceFactory<R> resourceFactory) throws InvalidResourceException {
        try {
            String json = FileUtils.read((InputStream)inputStream);
            JSONObject jsonObject = this.makeCaseInsensitive(new JSONObject(new JSONTokener(json)));
            NXJsonParser parser = new NXJsonParser();
            return parser.doUnmarshal(jsonObject, resourceDescriptor, resourceFactory, null);
        }
        catch (JSONException e) {
            throw new InvalidResourceException("Error while reading JSON: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new InvalidResourceException("Error while reading JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    protected JSONObject makeCaseInsensitive(JSONObject jsonObject) throws JSONException {
        if (jsonObject == null) {
            return null;
        }
        Iterator keys = jsonObject.keys();
        HashMap<String, Object> lowerCaseMap = new HashMap<String, Object>(jsonObject.length());
        while (keys.hasNext()) {
            String key = keys.next().toString();
            String lowerCaseKey = StaticUtils.toLowerCase((String)key);
            lowerCaseMap.put(lowerCaseKey, jsonObject.get(key));
        }
        return new JSONObject(lowerCaseMap);
    }
}

