/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.sdk.Resources;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.scim.server.jaxrs.marshalling.UserResponse;
import org.nuxeo.scim.server.jaxrs.usermanager.BaseUMObject;

@WebObject(type="users")
@Produces(value={"application/json", "application/xml"})
public class SCIMUserWebObject
extends BaseUMObject {
    @Override
    protected String getPrefix() {
        return "/Users";
    }

    protected UserResource resolveUserRessource(String uid) {
        try {
            DocumentModel userModel = this.um.getUserModel(uid);
            if (userModel != null) {
                return this.mapper.getUserResourceFromNuxeoUser(userModel);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while resolving User", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json", "application/xml; qs=0.9"})
    public Resources<UserResource> getUsers(@Context UriInfo uriInfo) {
        String[] filterParts;
        MultivaluedMap params = uriInfo.getQueryParameters();
        HashMap<String, String> filter = new HashMap<String, String>();
        List filters = (List)params.get("filter");
        if (filters != null && filters.size() > 0 && (filterParts = ((String)filters.get(0)).split(" "))[1].equals("eq")) {
            String value;
            String key = filterParts[0];
            if (key.equals("userName")) {
                key = "username";
            }
            if ((value = filterParts[2]).startsWith("\"")) {
                value = value.substring(1, value.length() - 2);
            }
            filter.put(key, value);
        }
        List sortCol = (List)params.get("sortBy");
        List sortType = (List)params.get("sortOrder");
        HashMap orderBy = new HashMap();
        if (sortCol != null && sortCol.size() > 0) {
            String order = "asc";
            if (sortType != null && sortType.size() > 0) {
                if (((String)sortType.get(0)).equalsIgnoreCase("descending")) {
                    order = "desc";
                }
                orderBy.put(sortCol.get(0), order);
            }
        }
        int startIndex = 1;
        if (params.get("startIndex") != null) {
            startIndex = Integer.parseInt((String)((List)params.get("startIndex")).get(0));
        }
        int count = 10;
        if (params.get("count") != null) {
            count = Integer.parseInt((String)((List)params.get("count")).get(0));
        }
        try {
            String directoryName = this.um.getUserDirectoryName();
            DirectoryService ds = (DirectoryService)Framework.getLocalService(DirectoryService.class);
            DocumentModelList userModels = null;
            try (Session dSession = null;){
                dSession = ds.open(directoryName);
                userModels = dSession.query(filter, null, orderBy, true, count, startIndex - 1);
            }
            ArrayList<UserResource> userResources = new ArrayList<UserResource>();
            for (DocumentModel userModel : userModels) {
                userResources.add(this.mapper.getUserResourceFromNuxeoUser(userModel));
            }
            return new Resources(userResources, userResources.size(), startIndex);
        }
        catch (Exception e) {
            log.error((Object)"Error while getting Users", (Throwable)e);
            return null;
        }
    }

    @Path(value="{uid}")
    @GET
    @Produces(value={"application/xml", "application/json"})
    public UserResource getUserResource(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        return this.resolveUserRessource(uid);
    }

    @Path(value="{uid}.xml")
    @GET
    @Produces(value={"application/xml"})
    public UserResource getUserResourceAsXml(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        return this.getUserResource(uriInfo, uid);
    }

    @Path(value="{uid}.json")
    @GET
    @Produces(value={"application/json"})
    public UserResource getUserResourceAsJSON(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        return this.getUserResource(uriInfo, uid);
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createUser(UserResource user) {
        return this.doCreateUserResponse(user, this.fixeMediaType);
    }

    protected Response doCreateUserResponse(UserResource user, MediaType mt) {
        try {
            this.checkUpdateGuardPreconditions();
            return UserResponse.created(this.doCreateUser(user), mt);
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    protected UserResource doCreateUser(UserResource user) {
        try {
            DocumentModel newUser = this.mapper.createNuxeoUserFromUserResource(user);
            UserResource resource = this.mapper.getUserResourceFromNuxeoUser(newUser);
            return resource;
        }
        catch (Exception e) {
            log.error((Object)"Unable to create User", (Throwable)e);
            return null;
        }
    }

    @PUT
    @Path(value="{uid}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updateUser(@Context UriInfo uriInfo, @PathParam(value="uid") String uid, UserResource user) {
        try {
            this.checkUpdateGuardPreconditions();
            return this.doUpdateUser(uid, user, this.fixeMediaType);
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    protected Response doUpdateUser(String uid, UserResource user, MediaType mt) {
        try {
            DocumentModel userModel = this.mapper.updateNuxeoUserFromUserResource(uid, user);
            if (userModel != null) {
                UserResource userResource = this.mapper.getUserResourceFromNuxeoUser(userModel);
                return UserResponse.updated(userResource, mt);
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to create User", (Throwable)e);
        }
        return null;
    }

    @Path(value="{uid}")
    @DELETE
    public Response deleteUserResource(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        try {
            this.um.deleteUser(uid);
            return Response.ok().build();
        }
        catch (DirectoryException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }
}

