/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.mapper;

import com.unboundid.scim.data.GroupResource;
import com.unboundid.scim.data.Meta;
import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.schema.CoreSchema;
import java.net.URI;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractMapper {
    protected UserManager um = (UserManager)Framework.getLocalService(UserManager.class);
    protected final String baseUrl;

    public AbstractMapper(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public GroupResource getGroupResourceFromNuxeoGroup(DocumentModel groupModel) throws Exception {
        GroupResource groupResource = new GroupResource(CoreSchema.GROUP_DESCRIPTOR);
        String groupId = (String)groupModel.getProperty(this.um.getGroupSchemaName(), this.um.getGroupIdField());
        URI location = new URI(this.baseUrl + "/" + groupId);
        Meta meta = new Meta(null, null, location, "1");
        groupResource.setMeta(meta);
        String groupLabel = (String)groupModel.getProperty(this.um.getGroupSchemaName(), this.um.getGroupLabelField());
        groupResource.setDisplayName(groupLabel);
        groupResource.setId(groupId);
        groupResource.setExternalId(groupId);
        return groupResource;
    }

    public DocumentModel createGroupModelFromGroupResource(GroupResource group) throws NuxeoException {
        if (this.um.getGroup(group.getId()) == null) {
            DocumentModel newGroup = this.um.getBareGroupModel();
            String groupId = group.getId();
            if (groupId == null || groupId.isEmpty()) {
                groupId = group.getDisplayName();
            }
            newGroup.setProperty(this.um.getGroupSchemaName(), this.um.getGroupIdField(), (Object)groupId);
            this.updateGroupModel(newGroup, group);
            return this.um.createGroup(newGroup);
        }
        return this.updateGroupModelFromGroupResource(group.getId(), group);
    }

    public DocumentModel updateGroupModelFromGroupResource(String uid, GroupResource group) throws NuxeoException {
        DocumentModel groupModel = this.um.getGroupModel(uid);
        if (groupModel == null) {
            return null;
        }
        this.updateGroupModel(groupModel, group);
        this.um.updateGroup(groupModel);
        return groupModel;
    }

    protected void updateGroupModel(DocumentModel userModel, GroupResource groupResouce) throws NuxeoException {
        String displayName = groupResouce.getDisplayName();
        if (displayName != null && !displayName.isEmpty()) {
            userModel.setProperty(this.um.getGroupSchemaName(), this.um.getGroupLabelField(), (Object)displayName);
        }
    }

    public abstract UserResource getUserResourceFromNuxeoUser(DocumentModel var1) throws Exception;

    public abstract DocumentModel createNuxeoUserFromUserResource(UserResource var1) throws NuxeoException;

    public abstract DocumentModel updateNuxeoUserFromUserResource(String var1, UserResource var2);
}

