/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.search.ui.localconfiguration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.localconfiguration.AbstractLocalConfiguration;
import org.nuxeo.search.ui.localconfiguration.SearchConfiguration;

public class SearchConfigurationAdapter
extends AbstractLocalConfiguration<SearchConfiguration>
implements SearchConfiguration {
    protected List<String> allowedContentViews;
    protected DocumentRef docRef;
    protected boolean canMerge = true;

    public SearchConfigurationAdapter(DocumentModel doc) {
        this.docRef = doc.getRef();
        this.allowedContentViews = this.getList(doc, "searchc:allowedContentViews");
    }

    protected List<String> getList(DocumentModel doc, String property) {
        String[] content;
        try {
            content = (String[])doc.getPropertyValue(property);
        }
        catch (PropertyException e) {
            return Collections.emptyList();
        }
        if (content != null) {
            return Collections.unmodifiableList(Arrays.asList(content));
        }
        return Collections.emptyList();
    }

    public DocumentRef getDocumentRef() {
        return this.docRef;
    }

    public boolean canMerge() {
        return this.canMerge;
    }

    public SearchConfiguration merge(SearchConfiguration other) {
        if (other == null) {
            return this;
        }
        this.docRef = other.getDocumentRef();
        if (this.allowedContentViews.isEmpty() && !other.getAllowedContentViewNames().isEmpty()) {
            this.allowedContentViews = Collections.unmodifiableList(other.getAllowedContentViewNames());
            this.canMerge = false;
        }
        return this;
    }

    @Override
    public List<String> getAllowedContentViewNames() {
        return this.allowedContentViews;
    }

    protected boolean isAllowedName(String name) {
        return this.getAllowedContentViewNames().contains(name);
    }

    @Override
    public List<String> filterAllowedContentViewNames(List<String> names) {
        if (this.allowedContentViews.isEmpty()) {
            return names;
        }
        ArrayList<String> filtered = new ArrayList<String>();
        for (String name : names) {
            if (!this.isAllowedName(name)) continue;
            filtered.add(name);
        }
        return filtered;
    }
}

