/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.facelets;

import com.sun.facelets.FaceletFactory;
import com.sun.facelets.FaceletViewHandler;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.impl.DefaultResourceResolver;
import com.sun.facelets.impl.ResourceResolver;
import com.sun.facelets.util.ReflectionUtil;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.jsf.facelets.NXThemesFaceletFactory;

public class NXThemesFaceletViewHandler
extends FaceletViewHandler {
    private static final Log log = LogFactory.getLog(NXThemesFaceletViewHandler.class);
    private static final String SEAM_EXPRESSION_FACTORY = "org.jboss.seam.el.SeamExpressionFactoryImpl";
    private static final long DEFAULT_REFRESH_PERIOD = 2L;
    private static final String PARAM_REFRESH_PERIOD = "facelets.REFRESH_PERIOD";
    private static final String PARAM_RESOURCE_RESOLVER = "facelets.RESOURCE_RESOLVER";

    public NXThemesFaceletViewHandler(ViewHandler parent) {
        super(parent);
    }

    protected Compiler createCompiler() {
        Compiler compiler = super.createCompiler();
        compiler.setFeature("compiler.ExpressionFactory", SEAM_EXPRESSION_FACTORY);
        return compiler;
    }

    protected FaceletFactory createFaceletFactory(Compiler c) {
        long refreshPeriod = 2L;
        FacesContext ctx = FacesContext.getCurrentInstance();
        String nuxRefreshPeriod = Framework.getProperty((String)PARAM_REFRESH_PERIOD);
        if (nuxRefreshPeriod != null && nuxRefreshPeriod.length() > 0) {
            refreshPeriod = Long.parseLong(nuxRefreshPeriod);
        } else {
            String userPeriod = ctx.getExternalContext().getInitParameter(PARAM_REFRESH_PERIOD);
            if (userPeriod != null && userPeriod.length() > 0) {
                refreshPeriod = Long.parseLong(userPeriod);
            }
        }
        DefaultResourceResolver resolver = new DefaultResourceResolver();
        String resolverName = ctx.getExternalContext().getInitParameter(PARAM_RESOURCE_RESOLVER);
        if (resolverName != null && resolverName.length() > 0) {
            try {
                resolver = (ResourceResolver)ReflectionUtil.forName((String)resolverName).newInstance();
            }
            catch (Exception e) {
                throw new FacesException("Error Initializing ResourceResolver[" + resolverName + "]", (Throwable)e);
            }
        }
        return new NXThemesFaceletFactory(c, (ResourceResolver)resolver, refreshPeriod);
    }
}

