/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.facelets.vendor;

import com.sun.facelets.Facelet;
import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.tag.jsf.ComponentSupport;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.nuxeo.theme.jsf.facelets.vendor.DefaultFaceletContext;
import org.nuxeo.theme.jsf.facelets.vendor.DefaultFaceletFactory;

public final class DefaultFacelet
extends Facelet {
    private final Logger log = Logger.getLogger("facelets.facelet");
    private static final String APPLIED_KEY = "com.sun.facelets.APPLIED";
    private final String alias;
    private final ExpressionFactory elFactory;
    private final DefaultFaceletFactory factory;
    private final long createTime;
    private final long refreshPeriod;
    private final Map relativePaths;
    private final FaceletHandler root;
    private final URL src;

    public DefaultFacelet(DefaultFaceletFactory factory, ExpressionFactory el, URL src, String alias, FaceletHandler root) {
        this.factory = factory;
        this.elFactory = el;
        this.src = src;
        this.root = root;
        this.alias = alias;
        this.createTime = System.currentTimeMillis();
        this.refreshPeriod = this.factory.getRefreshPeriod();
        this.relativePaths = new WeakHashMap();
    }

    public void apply(FacesContext facesContext, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        DefaultFaceletContext ctx = new DefaultFaceletContext(facesContext, this);
        this.refresh(parent);
        ComponentSupport.markForDeletion((UIComponent)parent);
        this.root.apply((FaceletContext)ctx, parent);
        ComponentSupport.finalizeForDeletion((UIComponent)parent);
        this.markApplied(parent);
    }

    private final void refresh(UIComponent c) {
        if (this.refreshPeriod > 0L) {
            ApplyToken token;
            int sz = c.getChildCount();
            if (sz > 0) {
                UIComponent cc = null;
                List cl = c.getChildren();
                while (--sz >= 0) {
                    cc = (UIComponent)cl.get(sz);
                    if (cc.isTransient() || (token = (ApplyToken)cc.getAttributes().get(APPLIED_KEY)) == null || token.time >= this.createTime || !token.alias.equals(this.alias)) continue;
                    if (this.log.isLoggable(Level.INFO)) {
                        DateFormat df = SimpleDateFormat.getTimeInstance();
                        this.log.info("Facelet[" + this.alias + "] was modified @ " + df.format(new Date(this.createTime)) + ", flushing component applied @ " + df.format(new Date(token.time)));
                    }
                    cl.remove(sz);
                }
            }
            if (c.getFacets().size() > 0) {
                Collection col = c.getFacets().values();
                Iterator itr = col.iterator();
                while (itr.hasNext()) {
                    UIComponent fc = (UIComponent)itr.next();
                    if (fc.isTransient() || (token = (ApplyToken)fc.getAttributes().get(APPLIED_KEY)) == null || token.time >= this.createTime || !token.alias.equals(this.alias)) continue;
                    if (this.log.isLoggable(Level.INFO)) {
                        DateFormat df = SimpleDateFormat.getTimeInstance();
                        this.log.info("Facelet[" + this.alias + "] was modified @ " + df.format(new Date(this.createTime)) + ", flushing component applied @ " + df.format(new Date(token.time)));
                    }
                    itr.remove();
                }
            }
        }
    }

    private final void markApplied(UIComponent parent) {
        if (this.refreshPeriod > 0L) {
            Iterator itr = parent.getFacetsAndChildren();
            ApplyToken token = new ApplyToken(this.alias, System.currentTimeMillis() + this.refreshPeriod);
            while (itr.hasNext()) {
                Map attr;
                UIComponent c = (UIComponent)itr.next();
                if (c.isTransient() || (attr = c.getAttributes()).containsKey(APPLIED_KEY)) continue;
                attr.put(APPLIED_KEY, token);
            }
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.elFactory;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    private URL getRelativePath(String path) throws IOException {
        URL url = (URL)this.relativePaths.get(path);
        if (url == null) {
            url = this.factory.resolveURL(this.src, path);
            this.relativePaths.put(path, url);
        }
        return url;
    }

    public URL getSource() {
        return this.src;
    }

    private void include(DefaultFaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        this.refresh(parent);
        this.root.apply((FaceletContext)new DefaultFaceletContext(ctx, this), parent);
        this.markApplied(parent);
    }

    public void include(DefaultFaceletContext ctx, UIComponent parent, String path) throws IOException, FacesException, FaceletException, ELException {
        URL url = this.getRelativePath(path);
        this.include(ctx, parent, url);
    }

    public void include(DefaultFaceletContext ctx, UIComponent parent, URL url) throws IOException, FacesException, FaceletException, ELException {
        Facelet f = this.factory.getFacelet(url);
        if (f instanceof DefaultFacelet) {
            ((DefaultFacelet)f).include(ctx, parent);
        } else {
            f.apply(ctx.getFacesContext(), parent);
        }
    }

    public String toString() {
        return this.alias;
    }

    private static class ApplyToken
    implements Externalizable {
        public String alias;
        public long time;

        public ApplyToken() {
        }

        public ApplyToken(String alias, long time) {
            this.alias = alias;
            this.time = time;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.alias = in.readUTF();
            this.time = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.alias);
            out.writeLong(this.time);
        }
    }
}

