/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.facelets.vendor;

import com.sun.facelets.Facelet;
import com.sun.facelets.FaceletException;
import com.sun.facelets.FaceletFactory;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.impl.ResourceResolver;
import com.sun.facelets.util.ParameterCheck;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.jsf.facelets.vendor.DefaultFacelet;
import org.nuxeo.theme.jsf.facelets.vendor.NotFoundFacelet;

public class DefaultFaceletFactory
extends FaceletFactory {
    protected static final Logger log = Logger.getLogger("facelets.factory");
    private final Compiler compiler;
    private Map facelets;
    private Map relativeLocations;
    private final ResourceResolver resolver;
    private final URL baseUrl;
    protected final long refreshPeriod;

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver) throws IOException {
        this(compiler, resolver, -1L);
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver, long refreshPeriod) {
        ParameterCheck.notNull((String)"compiler", (Object)compiler);
        ParameterCheck.notNull((String)"resolver", (Object)resolver);
        this.compiler = compiler;
        this.facelets = new HashMap();
        this.relativeLocations = new HashMap();
        this.resolver = resolver;
        this.baseUrl = resolver.resolveUrl("/");
        log.fine("Using ResourceResolver: " + resolver);
        this.refreshPeriod = refreshPeriod >= 0L ? refreshPeriod * 1000L : -1L;
        log.fine("Using Refresh Period: " + this.refreshPeriod);
    }

    public Facelet getFacelet(String uri) throws IOException, FaceletException, FacesException, ELException {
        URL url = (URL)this.relativeLocations.get(uri);
        if (url == null) {
            url = this.resolveURL(this.baseUrl, uri);
            if (url != null) {
                HashMap<String, URL> newLoc = new HashMap<String, URL>(this.relativeLocations);
                newLoc.put(uri, url);
                this.relativeLocations = newLoc;
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return this.getFacelet(url);
    }

    public URL resolveURL(URL source, String path) throws IOException {
        if (path.startsWith("/")) {
            URL url = this.resolver.resolveUrl(path);
            if (url == null) {
                throw new FileNotFoundException(path + " Not Found in ExternalContext as a Resource");
            }
            return url;
        }
        return new URL(source, path);
    }

    public Facelet getFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        ParameterCheck.notNull((String)"url", (Object)url);
        String key = url.toString();
        Facelet f = (Facelet)this.facelets.get(key);
        if (f == null || f instanceof DefaultFacelet && this.needsToBeRefreshed((DefaultFacelet)f)) {
            f = this.createFacelet(url);
            if (this.refreshPeriod != 0L) {
                HashMap<String, Facelet> newLoc = new HashMap<String, Facelet>(this.facelets);
                newLoc.put(key, f);
                this.facelets = newLoc;
            }
        }
        return f;
    }

    protected boolean needsToBeRefreshed(DefaultFacelet facelet) {
        if (this.refreshPeriod == 0L) {
            return true;
        }
        boolean devMode = Framework.isDevModeSet();
        if (!devMode && this.refreshPeriod == -1L) {
            return false;
        }
        long period = this.refreshPeriod;
        if (devMode && this.refreshPeriod == -1L) {
            period = 2000L;
        }
        long ttl = facelet.getCreateTime() + period;
        URL url = facelet.getSource();
        InputStream is = null;
        if (System.currentTimeMillis() > ttl) {
            try {
                URLConnection conn = url.openConnection();
                is = conn.getInputStream();
                long atl = conn.getLastModified();
                boolean bl = atl == 0L || atl > ttl;
                return bl;
            }
            catch (Exception e) {
                throw new FaceletException("Error Checking Last Modified for " + facelet.getAlias(), (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return false;
    }

    private Facelet createFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Facelet for: " + url);
        }
        String alias = "/" + url.getFile().replaceFirst(this.baseUrl.getFile(), "");
        try {
            FaceletHandler h = this.compiler.compile(url, alias);
            DefaultFacelet f = new DefaultFacelet(this, this.compiler.createExpressionFactory(), url, alias, h);
            return f;
        }
        catch (IOException e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.severe(alias + " not found at " + url.toExternalForm() + " : " + e.getMessage());
            }
            NotFoundFacelet f = new NotFoundFacelet(alias);
            return f;
        }
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }
}

