/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webwidgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.theme.Utils;
import org.nuxeo.theme.webwidgets.DecorationType;
import org.nuxeo.theme.webwidgets.PanelDecorationType;
import org.nuxeo.theme.webwidgets.ProviderType;
import org.nuxeo.theme.webwidgets.WidgetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service
extends DefaultComponent {
    public static final ComponentName ID = new ComponentName("org.nuxeo.theme.webwidgets.Service");
    private static final Log log = LogFactory.getLog(Service.class);
    private Map<String, WidgetType> widgetTypes;
    private Set<String> widgetCategories;
    private Map<String, ProviderType> providerTypes;
    private Map<String, DecorationType> decorationTypes;

    public void activate(ComponentContext context) {
        this.widgetTypes = new LinkedHashMap<String, WidgetType>();
        this.widgetCategories = new HashSet<String>();
        this.providerTypes = new LinkedHashMap<String, ProviderType>();
        this.decorationTypes = new LinkedHashMap<String, DecorationType>();
        log.debug((Object)"Web widgets service activated");
    }

    public void deactivate(ComponentContext context) {
        this.widgetTypes = null;
        this.widgetCategories = null;
        this.providerTypes = null;
        this.decorationTypes = null;
        log.debug((Object)"Web widgets service deactivated");
    }

    public void registerExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        if (xp.equals("widgets")) {
            this.registerWidget(extension);
        } else if (xp.equals("providers")) {
            this.registerProvider(extension);
        } else if (xp.equals("decorations")) {
            this.registerDecoration(extension);
        }
    }

    public void unregisterExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        if (xp.equals("widgets")) {
            this.unregisterWidget(extension);
        } else if (xp.equals("providers")) {
            this.unregisterProvider(extension);
        } else if (xp.equals("decorations")) {
            this.unregisterDecoration(extension);
        }
    }

    private void registerWidget(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            WidgetType widgetType = (WidgetType)contrib;
            this.initializeWidget(widgetType);
            String name = widgetType.getName();
            this.widgetTypes.put(name, widgetType);
            this.widgetCategories.add(widgetType.getCategory());
        }
    }

    private void registerProvider(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            ProviderType providerType = (ProviderType)contrib;
            String providerName = providerType.getName();
            this.providerTypes.put(providerName, providerType);
        }
    }

    private void registerDecoration(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            DecorationType decorationType = (DecorationType)contrib;
            String decorationName = decorationType.getName();
            this.decorationTypes.put(decorationName, decorationType);
        }
    }

    private void unregisterWidget(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            WidgetType widgetType = (WidgetType)contrib;
            this.widgetTypes.remove(widgetType.getName());
            this.widgetCategories.remove(widgetType.getCategory());
        }
    }

    private void unregisterProvider(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            ProviderType providerType = (ProviderType)contrib;
            this.providerTypes.remove(providerType.getName());
        }
    }

    private void unregisterDecoration(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            DecorationType decorationType = (DecorationType)contrib;
            this.decorationTypes.remove(decorationType.getName());
        }
    }

    public List<String> getProviderNames() {
        return new ArrayList<String>(this.providerTypes.keySet());
    }

    public List<String> getDecorationNames() {
        return new ArrayList<String>(this.decorationTypes.keySet());
    }

    public List<String> getWidgetTypeNames() {
        return new ArrayList<String>(this.widgetTypes.keySet());
    }

    public List<WidgetType> getWidgetTypes(String category) {
        ArrayList<WidgetType> types = new ArrayList<WidgetType>();
        for (Map.Entry<String, WidgetType> entry : this.widgetTypes.entrySet()) {
            WidgetType widgetType = entry.getValue();
            if (!category.equals("") && !widgetType.getCategory().equals(category)) continue;
            types.add(widgetType);
        }
        return types;
    }

    public WidgetType getWidgetType(String widgetTypeName) {
        return this.widgetTypes.get(widgetTypeName);
    }

    private void initializeWidget(WidgetType widgetType) {
        String path = widgetType.getPath();
        String source = Utils.readResourceAsString((String)path);
        widgetType.setSource(source);
        String icon = org.nuxeo.theme.webwidgets.Utils.extractIcon(source);
        if (icon != null) {
            widgetType.setIcon(icon);
        }
        widgetType.setAuthor(org.nuxeo.theme.webwidgets.Utils.extractMetadata(source, "author"));
        widgetType.setDescription(org.nuxeo.theme.webwidgets.Utils.extractMetadata(source, "description"));
        widgetType.setThumbnail(org.nuxeo.theme.webwidgets.Utils.extractMetadata(source, "thumbnail"));
        widgetType.setScreenshot(org.nuxeo.theme.webwidgets.Utils.extractMetadata(source, "screenshot"));
        widgetType.setWebsite(org.nuxeo.theme.webwidgets.Utils.extractMetadata(source, "website"));
        widgetType.setSchema(org.nuxeo.theme.webwidgets.Utils.extractSchema(source));
        widgetType.setScripts(org.nuxeo.theme.webwidgets.Utils.extractScripts(source));
        widgetType.setStyles(org.nuxeo.theme.webwidgets.Utils.extractStyles(source));
        widgetType.setBody(org.nuxeo.theme.webwidgets.Utils.extractBody(source));
    }

    public Set<String> getWidgetCategories() {
        return this.widgetCategories;
    }

    public ProviderType getProviderType(String name) {
        return this.providerTypes.get(name);
    }

    public DecorationType getDecorationType(String name) {
        return this.decorationTypes.get(name);
    }

    public String getPanelDecoration(String decorationName, String mode) {
        DecorationType decorationType = this.getDecorationType(decorationName);
        PanelDecorationType panelDecorationType = decorationType.getPanelDecoration(mode);
        if (panelDecorationType == null) {
            return "";
        }
        return panelDecorationType.getContent();
    }
}

