/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webwidgets.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.session.UserSession;
import org.nuxeo.theme.webwidgets.DefaultWidget;
import org.nuxeo.theme.webwidgets.Provider;
import org.nuxeo.theme.webwidgets.ProviderException;
import org.nuxeo.theme.webwidgets.Widget;
import org.nuxeo.theme.webwidgets.WidgetData;
import org.nuxeo.theme.webwidgets.WidgetState;
import org.nuxeo.theme.webwidgets.providers.DefaultProviderSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProvider
implements Provider {
    private static final Log log = LogFactory.getLog(DefaultProvider.class);
    private static final String PROVIDER_SESSION_ID = "org.nuxeo.theme.webwidgets.default_provider_session";

    public DefaultProviderSession getDefaultProviderSession() {
        UserSession userSession = WebEngine.getActiveContext().getUserSession();
        DefaultProviderSession session = (DefaultProviderSession)userSession.get((Object)PROVIDER_SESSION_ID);
        if (session == null) {
            session = new DefaultProviderSession();
            userSession.put((Object)PROVIDER_SESSION_ID, (Object)session);
        }
        return session;
    }

    @Override
    public Widget createWidget(String widgetTypeName) throws ProviderException {
        if (widgetTypeName == null) {
            throw new ProviderException("Widget type name is undefined");
        }
        DefaultProviderSession session = this.getDefaultProviderSession();
        int counter = session.getCounter();
        String uid = Integer.toString(counter);
        session.setCounter(++counter);
        DefaultWidget widget = new DefaultWidget(widgetTypeName, uid);
        session.getWidgetsByUid().put(uid, widget);
        log.debug((Object)("Created web widget '" + widgetTypeName + "' (uid " + uid + ")"));
        return widget;
    }

    @Override
    public Widget getWidgetByUid(String uid) throws ProviderException {
        DefaultProviderSession session = this.getDefaultProviderSession();
        Widget widget = session.getWidgetsByUid().get(uid);
        if (widget == null) {
            throw new ProviderException("Widget not found: " + uid);
        }
        return widget;
    }

    @Override
    public List<Widget> getWidgets(String regionName) throws ProviderException {
        if (regionName == null) {
            throw new ProviderException("Region name is undefined");
        }
        DefaultProviderSession session = this.getDefaultProviderSession();
        return session.getWidgetsByRegion().get(regionName);
    }

    @Override
    public void addWidget(Widget widget, String regionName, int order) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (regionName == null) {
            throw new ProviderException("Region name is undefined");
        }
        DefaultProviderSession session = this.getDefaultProviderSession();
        Map<String, List<Widget>> widgetsByRegion = session.getWidgetsByRegion();
        if (!widgetsByRegion.containsKey(regionName)) {
            widgetsByRegion.put(regionName, new ArrayList());
        }
        widgetsByRegion.get(regionName).add(order, widget);
        session.getRegionsByUid().put(widget.getUid(), regionName);
        log.debug((Object)("Added web widget '" + widget.getName() + "' (uid " + widget.getUid() + ") into region '" + regionName + "' at position " + order));
    }

    @Override
    public void moveWidget(Widget widget, String destRegionName, int order) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (destRegionName == null) {
            throw new ProviderException("Destination region name is undefined.");
        }
        DefaultProviderSession session = this.getDefaultProviderSession();
        String srcRegionName = this.getRegionOfWidget(widget);
        Map<String, List<Widget>> widgetsByRegion = session.getWidgetsByRegion();
        widgetsByRegion.get(srcRegionName).remove(widget);
        if (!widgetsByRegion.containsKey(destRegionName)) {
            widgetsByRegion.put(destRegionName, new ArrayList());
        }
        widgetsByRegion.get(destRegionName).add(order, widget);
        session.getRegionsByUid().put(widget.getUid(), destRegionName);
        log.debug((Object)("Moved web widget '" + widget.getName() + "' (uid " + widget.getUid() + ") from region '" + srcRegionName + "' to '" + destRegionName + "' at position " + order));
    }

    @Override
    public void reorderWidget(Widget widget, int order) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        DefaultProviderSession session = this.getDefaultProviderSession();
        String regionName = this.getRegionOfWidget(widget);
        Map<String, List<Widget>> widgetsByRegion = session.getWidgetsByRegion();
        List<Widget> widgets = widgetsByRegion.get(regionName);
        int oldOrder = widgets.indexOf(widget);
        widgets.remove(oldOrder);
        widgets.add(order, widget);
        log.debug((Object)("Reordered web widget '" + widget.getName() + "' (uid " + widget.getUid() + ") in region '" + regionName + "' to position " + order));
    }

    @Override
    public void removeWidget(Widget widget) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        DefaultProviderSession session = this.getDefaultProviderSession();
        String uid = widget.getUid();
        String regionName = this.getRegionOfWidget(widget);
        Map<String, List<Widget>> widgetsByRegion = session.getWidgetsByRegion();
        widgetsByRegion.get(regionName).remove(widget);
        session.getWidgetsByUid().remove(uid);
        log.debug((Object)("Removed web widget '" + widget.getName() + "' (uid " + uid + ") from region '" + regionName + "'"));
    }

    @Override
    public String getRegionOfWidget(Widget widget) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        DefaultProviderSession session = this.getDefaultProviderSession();
        return session.getRegionsByUid().get(widget.getUid());
    }

    @Override
    public Map<String, String> getWidgetPreferences(Widget widget) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        DefaultProviderSession session = this.getDefaultProviderSession();
        return session.getPreferencesByWidget().get(widget);
    }

    @Override
    public void setWidgetPreferences(Widget widget, Map<String, String> preferences) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (preferences == null) {
            throw new ProviderException("Widget preferences are undefined");
        }
        DefaultProviderSession session = this.getDefaultProviderSession();
        session.getPreferencesByWidget().put(widget, preferences);
    }

    @Override
    public void setWidgetState(Widget widget, WidgetState state) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (state == null) {
            throw new ProviderException("Widget state is undefined");
        }
        DefaultProviderSession session = this.getDefaultProviderSession();
        session.getStatesByWidget().put(widget, state);
    }

    @Override
    public WidgetState getWidgetState(Widget widget) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        DefaultProviderSession session = this.getDefaultProviderSession();
        return session.getStatesByWidget().get(widget);
    }

    @Override
    public WidgetData getWidgetData(Widget widget, String dataName) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (dataName == null || "".equals(dataName)) {
            throw new ProviderException("Data name is undefined");
        }
        DefaultProviderSession session = this.getDefaultProviderSession();
        Map<Widget, Map<String, WidgetData>> dataByWidget = session.getDataByWidget();
        if (dataByWidget.containsKey(widget)) {
            return dataByWidget.get(widget).get(dataName);
        }
        return null;
    }

    @Override
    public void setWidgetData(Widget widget, String dataName, WidgetData data) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (dataName == null || "".equals(dataName)) {
            throw new ProviderException("Data name is undefined");
        }
        DefaultProviderSession session = this.getDefaultProviderSession();
        Map<Widget, Map<String, WidgetData>> dataByWidget = session.getDataByWidget();
        if (!dataByWidget.containsKey(widget)) {
            dataByWidget.put(widget, new HashMap());
        }
        dataByWidget.get(widget).put(dataName, data);
    }

    @Override
    public void deleteWidgetData(Widget widget) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        DefaultProviderSession session = this.getDefaultProviderSession();
        Map<Widget, Map<String, WidgetData>> dataByWidget = session.getDataByWidget();
        if (dataByWidget.containsKey(widget)) {
            dataByWidget.remove(widget);
        }
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    public void destroy() {
    }
}

