/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webwidgets.providers;

import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ejb.Ejb3Configuration;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.theme.webwidgets.providers.DataEntity;
import org.nuxeo.theme.webwidgets.providers.WidgetEntity;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class PersistenceConfigurator
extends DefaultComponent
implements FrameworkListener {
    private static final Log log = LogFactory.getLog(PersistenceConfigurator.class);
    protected static EntityManagerFactory emf;
    protected static DataSource ds;
    private static final String DEFAULT_DATASOURCE = "jdbc/nxwebwidgets";

    public void activate(ComponentContext context) throws Exception {
        context.getRuntimeContext().getBundle().getBundleContext().addFrameworkListener((FrameworkListener)this);
    }

    public void deactivate(ComponentContext context) throws Exception {
        context.getRuntimeContext().getBundle().getBundleContext().removeFrameworkListener((FrameworkListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            ClassLoader jbossCL = Thread.currentThread().getContextClassLoader();
            ClassLoader nuxeoCL = PersistenceConfigurator.class.getClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(nuxeoCL);
                log.info((Object)"Service initialization");
                this.initPersistenceUnit();
            }
            finally {
                Thread.currentThread().setContextClassLoader(jbossCL);
                log.debug((Object)"Server ClassLoader restored");
            }
        }
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.put("hibernate.connection.autocommit", (Object)true);
        properties.put("hibernate.show_sql", (Object)false);
        properties.put("hibernate.hbm2ddl.auto", "update");
        properties.put("hibernate.connection.datasource", DEFAULT_DATASOURCE);
        return properties;
    }

    protected synchronized void initPersistenceUnit() {
        Ejb3Configuration cfg = new Ejb3Configuration();
        cfg.configure("fake-hibernate.cfg.xml");
        cfg.addProperties(this.getProperties());
        cfg.addAnnotatedClass(WidgetEntity.class);
        cfg.addAnnotatedClass(DataEntity.class);
        emf = cfg.buildEntityManagerFactory();
    }

    public static EntityManager getEntityManager() {
        if (emf != null) {
            return emf.createEntityManager();
        }
        log.error((Object)"Unable to get EntityManager, there is no factory");
        return null;
    }
}

