/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webwidgets.providers;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.theme.webwidgets.ProviderException;
import org.nuxeo.theme.webwidgets.Widget;
import org.nuxeo.theme.webwidgets.providers.PersistentProvider;
import org.nuxeo.theme.webwidgets.providers.WidgetEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentProviderPerUser
extends PersistentProvider {
    private static final Log log = LogFactory.getLog(PersistentProviderPerUser.class);

    @Override
    public synchronized Widget createWidget(String widgetTypeName) throws ProviderException {
        if (widgetTypeName == null) {
            throw new ProviderException("Widget type name is undefined");
        }
        if (this.currentNuxeoPrincipal == null) {
            log.warn((Object)"Could not get the current user from the context.");
            return null;
        }
        WidgetEntity widget = new WidgetEntity(widgetTypeName);
        widget.setScope(this.currentNuxeoPrincipal.getName());
        this.begin();
        this.em.persist((Object)widget);
        this.commit();
        return widget;
    }

    @Override
    public synchronized List<Widget> getWidgets(String regionName) throws ProviderException {
        if (regionName == null) {
            throw new ProviderException("Region name is undefined");
        }
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        if (this.currentNuxeoPrincipal != null) {
            widgets.addAll(this.em.createNamedQuery("Widget.findByScope").setParameter("region", (Object)regionName).setParameter("scope", (Object)this.currentNuxeoPrincipal.getName()).getResultList());
        }
        return widgets;
    }

    @Override
    public boolean canRead() {
        if (this.currentNuxeoPrincipal == null) {
            log.warn((Object)"Could not get the current user from the context.");
            return false;
        }
        return !((NuxeoPrincipal)this.currentNuxeoPrincipal).isAnonymous();
    }

    @Override
    public boolean canWrite() {
        if (this.currentNuxeoPrincipal == null) {
            log.warn((Object)"Could not get the current user from the context.");
            return false;
        }
        return !((NuxeoPrincipal)this.currentNuxeoPrincipal).isAnonymous();
    }
}

