/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webwidgets;

import org.nuxeo.theme.fragments.AbstractFragment;
import org.nuxeo.theme.models.Model;
import org.nuxeo.theme.properties.FieldInfo;
import org.nuxeo.theme.webwidgets.RegionModel;

public final class AreaFragment
extends AbstractFragment {
    @FieldInfo(type="string", label="region name", description="The name of the region.", required=true)
    public String name = "";
    @FieldInfo(type="selection", label="provider", source="web widget providers", description="The widget provider.", required=true)
    public String provider = "default";
    @FieldInfo(type="selection", label="decoration", source="web widget decorations", description="The panel and widget decoration.", required=true)
    public String decoration = "default";
    @FieldInfo(type="integer", label="maximum number of widgets", description="The maximum number of widgets allowed in this area.")
    public Integer maxItems;
    @FieldInfo(type="boolean", label="Disallow duplicates", description="Do not allow more than one widget of the same type in this area.")
    public Boolean disallowDuplicates;

    public AreaFragment() {
    }

    public AreaFragment(String name, String provider, String decoration, Integer maxItems, Boolean disallowDuplicates) {
        this.name = name;
        this.provider = provider;
        this.decoration = decoration;
        this.maxItems = maxItems;
        this.disallowDuplicates = disallowDuplicates;
    }

    public Model getModel() {
        return new RegionModel(this.name, this.provider, this.decoration);
    }

    public String getProviderName() {
        return this.provider;
    }

    public String getRegionName() {
        return this.name;
    }

    public String getDecoration() {
        return this.decoration;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Boolean getDisallowDuplicates() {
        return this.disallowDuplicates;
    }
}

