/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webwidgets.providers;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.persistence.PersistenceProvider;
import org.nuxeo.ecm.core.persistence.PersistenceProviderFactory;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.webwidgets.Provider;
import org.nuxeo.theme.webwidgets.ProviderException;
import org.nuxeo.theme.webwidgets.Widget;
import org.nuxeo.theme.webwidgets.WidgetData;
import org.nuxeo.theme.webwidgets.WidgetState;
import org.nuxeo.theme.webwidgets.providers.DataEntity;
import org.nuxeo.theme.webwidgets.providers.WidgetEntity;

public class PersistentProvider
implements Provider {
    private static final Log log = LogFactory.getLog(PersistentProvider.class);
    protected PersistenceProvider persistenceProvider;

    @Override
    public void activate() {
        PersistenceProviderFactory persistenceProviderFactory = (PersistenceProviderFactory)Framework.getLocalService(PersistenceProviderFactory.class);
        this.persistenceProvider = persistenceProviderFactory.newProvider("nxwebwidgets");
        this.persistenceProvider.openPersistenceUnit();
    }

    @Override
    public void deactivate() {
        if (this.persistenceProvider != null) {
            this.persistenceProvider.closePersistenceUnit();
            this.persistenceProvider = null;
        }
    }

    @Override
    public void destroy() throws ProviderException {
        try {
            this.getPersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    em.createQuery("DELETE FROM DataEntity data").executeUpdate();
                    for (Object w : em.createQuery("FROM WidgetEntity widget").getResultList()) {
                        em.remove(w);
                    }
                }
            });
        }
        catch (ClientException e) {
            throw new ProviderException(e);
        }
    }

    public PersistenceProvider getPersistenceProvider() {
        if (this.persistenceProvider == null) {
            this.activate();
        }
        return this.persistenceProvider;
    }

    public Principal getCurrentPrincipal() {
        WebContext ctx = WebEngine.getActiveContext();
        if (ctx != null) {
            return ctx.getPrincipal();
        }
        return null;
    }

    @Override
    public void addWidget(final Widget widget, final String regionName, int order) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (regionName == null) {
            throw new ProviderException("Region name is undefined");
        }
        List<Widget> widgets = this.getWidgets(regionName);
        widgets.add(order, widget);
        this.reorderWidgets(widgets);
        try {
            this.getPersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    ((WidgetEntity)widget).setRegion(regionName);
                    em.merge((Object)widget);
                }
            });
        }
        catch (ClientException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    public synchronized Widget createWidget(final String widgetTypeName) throws ProviderException {
        if (widgetTypeName == null) {
            throw new ProviderException("Widget type name is undefined");
        }
        try {
            return (Widget)this.getPersistenceProvider().run(Boolean.valueOf(true), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<Widget>(){

                public Widget runWith(EntityManager em) {
                    WidgetEntity widget = new WidgetEntity(widgetTypeName);
                    em.persist((Object)widget);
                    return widget;
                }
            });
        }
        catch (ClientException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    public String getRegionOfWidget(Widget widget) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        return ((WidgetEntity)widget).getRegion();
    }

    @Override
    public WidgetState getWidgetState(Widget widget) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        return ((WidgetEntity)widget).getState();
    }

    @Override
    public synchronized Widget getWidgetByUid(final String uid) throws ProviderException {
        Widget widget;
        try {
            widget = (Widget)this.getPersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<Widget>(){

                public Widget runWith(EntityManager em) {
                    Widget widget = (Widget)em.find(WidgetEntity.class, (Object)Integer.valueOf(uid));
                    return widget;
                }
            });
        }
        catch (ClientException e) {
            throw new ProviderException(e);
        }
        if (widget == null) {
            throw new ProviderException("Widget not found: " + uid);
        }
        return widget;
    }

    @Override
    public synchronized List<Widget> getWidgets(final String regionName) throws ProviderException {
        if (regionName == null) {
            throw new ProviderException("Region name is undefined.");
        }
        try {
            return (List)this.getPersistenceProvider().run(Boolean.valueOf(true), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<Widget>>(){

                public List<Widget> runWith(EntityManager em) {
                    Query query = em.createNamedQuery("Widget.findAll");
                    query.setParameter("region", (Object)regionName);
                    return query.getResultList();
                }
            });
        }
        catch (ClientException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    public void moveWidget(Widget widget, String destRegionName, int order) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (destRegionName == null) {
            throw new ProviderException("Destination region name is undefined.");
        }
        WidgetEntity widgetEntity = (WidgetEntity)widget;
        String srcRegionName = widgetEntity.getRegion();
        List<Widget> srcWidgets = this.getWidgets(srcRegionName);
        srcWidgets.remove(widget);
        this.reorderWidgets(srcWidgets);
        widgetEntity.setRegion(null);
        List<Widget> destWidgets = this.getWidgets(destRegionName);
        widgetEntity.setRegion(destRegionName);
        destWidgets.add(order, widgetEntity);
        this.reorderWidgets(destWidgets);
    }

    @Override
    public synchronized void removeWidget(Widget widget) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        WidgetEntity widgetEntity = (WidgetEntity)widget;
        final int id = widgetEntity.getId();
        try {
            this.getPersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    WidgetEntity w = (WidgetEntity)em.getReference(WidgetEntity.class, (Object)id);
                    em.remove((Object)w);
                }
            });
        }
        catch (ClientException e) {
            throw new ProviderException(e);
        }
        List<Widget> widgets = this.getWidgets(widgetEntity.getRegion());
        this.reorderWidgets(widgets);
    }

    @Override
    public void reorderWidget(Widget widget, int order) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        WidgetEntity widgetEntity = (WidgetEntity)widget;
        List<Widget> widgets = this.getWidgets(widgetEntity.getRegion());
        widgets.remove(widget);
        widgets.add(order, widget);
        this.reorderWidgets(widgets);
    }

    @Override
    public Map<String, String> getWidgetPreferences(Widget widget) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        return ((WidgetEntity)widget).getPreferences();
    }

    @Override
    public void setWidgetPreferences(final Widget widget, final Map<String, String> preferences) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (preferences == null) {
            throw new ProviderException("Widget preferences are undefined");
        }
        try {
            this.getPersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    ((WidgetEntity)widget).setPreferences(preferences);
                    em.merge((Object)widget);
                }
            });
        }
        catch (ClientException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    public void setWidgetState(final Widget widget, final WidgetState state) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (state == null) {
            throw new ProviderException("Widget state is undefined");
        }
        try {
            this.getPersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    ((WidgetEntity)widget).setState(state);
                    em.merge((Object)widget);
                }
            });
        }
        catch (ClientException e) {
            throw new ProviderException(e);
        }
    }

    public synchronized void reorderWidgets(final List<Widget> widgets) throws ProviderException {
        try {
            this.getPersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    int i = 0;
                    for (Widget w : widgets) {
                        WidgetEntity widget = (WidgetEntity)w;
                        int order = widget.getOrder();
                        if (order != i) {
                            ((WidgetEntity)w).setOrder(i);
                            em.merge((Object)w);
                        }
                        ++i;
                    }
                }
            });
        }
        catch (ClientException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    public synchronized WidgetData getWidgetData(final Widget widget, final String dataName) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (dataName == null || "".equals(dataName)) {
            throw new ProviderException("Data name is undefined");
        }
        try {
            return (WidgetData)this.getPersistenceProvider().run(Boolean.valueOf(true), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<WidgetData>(){

                public WidgetData runWith(EntityManager em) {
                    Query query = em.createNamedQuery("Data.findByWidgetAndName");
                    query.setParameter("widgetUid", (Object)widget.getUid());
                    query.setParameter("dataName", (Object)dataName);
                    List results = query.getResultList();
                    if (results.size() > 0) {
                        DataEntity dataEntity = (DataEntity)results.get(0);
                        return dataEntity.getData();
                    }
                    return null;
                }
            });
        }
        catch (ClientException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    public synchronized void setWidgetData(final Widget widget, final String dataName, final WidgetData data) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (dataName == null || "".equals(dataName)) {
            throw new ProviderException("Data name is undefined");
        }
        try {
            this.getPersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    Query query = em.createNamedQuery("Data.findByWidgetAndName");
                    query.setParameter("widgetUid", (Object)widget.getUid());
                    query.setParameter("dataName", (Object)dataName);
                    List results = query.getResultList();
                    DataEntity dataEntity = results.size() > 0 ? (DataEntity)results.get(0) : new DataEntity(widget.getUid(), dataName);
                    dataEntity.setData(data);
                    em.merge((Object)dataEntity);
                }
            });
        }
        catch (ClientException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    public synchronized void deleteWidgetData(final Widget widget) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        try {
            this.getPersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    Query query = em.createNamedQuery("Data.findByWidget");
                    query.setParameter("widgetUid", (Object)widget.getUid());
                    for (Object dataEntity : query.getResultList()) {
                        em.remove(dataEntity);
                    }
                }
            });
        }
        catch (ClientException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        Principal currentNuxeoPrincipal = this.getCurrentPrincipal();
        if (currentNuxeoPrincipal == null) {
            log.warn((Object)"Could not get the current user from the context.");
            return false;
        }
        return ((NuxeoPrincipal)currentNuxeoPrincipal).isMemberOf("administrators");
    }
}

