/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.converter;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.runtime.api.Framework;

public class ThumbnailDocumentConverter
implements Converter {
    public static final String THUMBNAIL_CONVERTER_NAME = "toThumbnail";
    public static final String THUMBNAIL_SIZE_PARAMETER_NAME = "size";
    public static final String THUMBNAIL_DEFAULT_SIZE = "100x100";
    public static final String THUMBNAIL_COMMAND = "toThumbnail";

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        try {
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
            CommandAvailability commandAvailability = cles.getCommandAvailability("toThumbnail");
            if (!commandAvailability.isAvailable()) {
                return null;
            }
            Blob blob = blobHolder.getBlob();
            Blob targetBlob = Blobs.createBlobWithExtension((String)".png");
            targetBlob.setMimeType("image/png");
            try (CloseableFile source = blob.getCloseableFile();){
                CmdParameters params = cles.getDefaultCmdParameters();
                String size = parameters != null && parameters.containsKey(THUMBNAIL_SIZE_PARAMETER_NAME) ? (String)((Object)parameters.get(THUMBNAIL_SIZE_PARAMETER_NAME)) : THUMBNAIL_DEFAULT_SIZE;
                params.addNamedParameter(THUMBNAIL_SIZE_PARAMETER_NAME, size);
                params.addNamedParameter("inputFilePath", source.getFile());
                params.addNamedParameter("outputFilePath", targetBlob.getFile());
                ExecResult res = cles.execCommand("toThumbnail", params);
                if (!res.isSuccessful()) {
                    throw res.getError();
                }
            }
            return new SimpleCachableBlobHolder(targetBlob);
        }
        catch (IOException | NuxeoException | CommandException | CommandNotAvailable e) {
            throw new ConversionException("Thumbnail conversion failed", e);
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

