/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.dashboard;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.user.center.dashboard.AbstractDashboardSpaceCreator;

public class DefaultDashboardSpaceCreator
extends AbstractDashboardSpaceCreator {
    public static final String DEFAULT_DASHBOARD_SPACE_NAME = "defaultDashboardSpace";
    public static final String POWER_USERS_GROUP = "powerusers";
    private static final Log log = LogFactory.getLog(DefaultDashboardSpaceCreator.class);
    public DocumentRef defaultDashboardSpaceRef;

    public DefaultDashboardSpaceCreator(CoreSession session, Map<String, String> parameters) {
        super(session, parameters);
    }

    public void run() throws ClientException {
        DocumentModel dashboardManagement = this.getDashboardManagement();
        String defaultDashboardSpacePath = new Path(dashboardManagement.getPathAsString()).append(DEFAULT_DASHBOARD_SPACE_NAME).toString();
        PathRef defaultDashboardSpacePathRef = new PathRef(defaultDashboardSpacePath);
        DocumentModel defaultDashboardSpace = !this.session.exists((DocumentRef)defaultDashboardSpacePathRef) ? this.createDefaultDashboardSpace(dashboardManagement.getPathAsString()) : this.session.getDocument((DocumentRef)defaultDashboardSpacePathRef);
        this.defaultDashboardSpaceRef = defaultDashboardSpace.getRef();
    }

    protected DocumentModel createDefaultDashboardSpace(String dashboardManagementPath) throws ClientException {
        DocumentModel defaultDashboardSpace = this.session.createDocumentModel(dashboardManagementPath, DEFAULT_DASHBOARD_SPACE_NAME, "Space");
        defaultDashboardSpace.setPropertyValue("dc:title", (Serializable)((Object)"default dashboard space"));
        defaultDashboardSpace.setPropertyValue("dc:description", (Serializable)((Object)"default dashboard space"));
        defaultDashboardSpace = this.session.createDocument(defaultDashboardSpace);
        this.addInitialGadgets(defaultDashboardSpace);
        this.addDefaultACP(defaultDashboardSpace);
        return this.session.saveDocument(defaultDashboardSpace);
    }

    protected void addDefaultACP(DocumentModel defaultDashboardSpace) throws ClientException {
        ACP acp = defaultDashboardSpace.getACP();
        ACL acl = acp.getOrCreateACL();
        for (String group : this.getUserManager().getAdministratorsGroups()) {
            acl.add((Object)new ACE(group, "Everything", true));
        }
        acl.add((Object)new ACE(POWER_USERS_GROUP, "Everything", true));
        defaultDashboardSpace.setACP(acp, true);
    }
}

