/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile.localeProvider;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.ecm.webapp.locale.LocaleStartup;
import org.nuxeo.runtime.api.Framework;

public class UserLocaleSelectorListener
implements EventListener {
    public static final Log log = LogFactory.getLog(UserLocaleSelectorListener.class);

    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext ctx = (DocumentEventContext)event.getContext();
        DocumentModel userProfileDocument = ctx.getSourceDocument();
        if (!userProfileDocument.hasFacet("UserProfile")) {
            return;
        }
        UserProfileService userProfileService = (UserProfileService)Framework.getLocalService(UserProfileService.class);
        DocumentModel userProfileDoc = userProfileService.getUserProfileDocument(ctx.getCoreSession());
        if (!userProfileDoc.getId().equals(userProfileDocument.getId())) {
            return;
        }
        LocaleStartup localeStartup = LocaleStartup.instance();
        if (localeStartup == null) {
            log.warn((Object)"Locale Startup not available. Can't set locale");
            return;
        }
        localeStartup.setupLocale(ctx.getCoreSession());
    }
}

