/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.usersettings.web;

import java.io.Serializable;
import java.util.Set;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.usersettings.UserSettingsService;
import org.nuxeo.runtime.api.Framework;

@Name(value="userSettingsActions")
@Scope(value=ScopeType.CONVERSATION)
public class UserSettingsManagerActionsBean
implements Serializable {
    private static final long serialVersionUID = 1828592026739219850L;
    protected String currentCategory = "Default";
    protected DocumentModelList currentSettingsProvider;
    private transient UserSettingsService userPreferencesService;
    @In(required=true)
    private transient CoreSession documentManager;

    private UserSettingsService getUserSettingsService() {
        if (this.userPreferencesService != null) {
            return this.userPreferencesService;
        }
        try {
            this.userPreferencesService = (UserSettingsService)Framework.getService(UserSettingsService.class);
            return this.userPreferencesService;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Set<String> getAvailableCategories() {
        return this.getUserSettingsService().getCategories();
    }

    public String getCurrentCategory() {
        return this.currentCategory;
    }

    public void setCurrentCategory(String currentCategory) throws ClientException {
        this.currentCategory = currentCategory;
        this.currentSettingsProvider = this.getUserSettingsService().getCurrentSettingsByCategory(this.documentManager, currentCategory);
    }

    public DocumentModelList getCurrentSettings() throws ClientException {
        if (this.currentSettingsProvider == null) {
            this.currentSettingsProvider = this.getUserSettingsService().getCurrentSettingsByCategory(this.documentManager, this.currentCategory);
        }
        return this.currentSettingsProvider;
    }

    public void saveCurrentSettings() throws ClientException {
        for (DocumentModel doc : this.currentSettingsProvider) {
            this.documentManager.saveDocument(doc);
        }
    }

    public void resetCurrentSettingCategory() throws ClientException {
        this.getUserSettingsService().resetSettingsCategory(this.documentManager, this.currentCategory);
        this.currentSettingsProvider = this.getUserSettingsService().getCurrentSettingsByCategory(this.documentManager, this.currentCategory);
    }
}

