/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.usermapper.test;

import com.google.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.nuxeo.usermapper.service.UserMapperService;
import org.nuxeo.usermapper.test.UserMapperFeature;
import org.nuxeo.usermapper.test.dummy.DummyUser;

@RunWith(value=FeaturesRunner.class)
@Features(value={UserMapperFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.usermapper:usermapper-contribs.xml"}), @Deploy(value={"org.nuxeo.ecm.platform.userworkspace"}), @Deploy(value={"org.nuxeo.ecm.user.center.profile"})})
public class TestUserMapperService {
    @Inject
    CoreSession session;

    @Test
    public void shouldDeclareService() throws Exception {
        UserMapperService ums = (UserMapperService)Framework.getService(UserMapperService.class);
        Assert.assertNotNull((Object)ums);
        Assert.assertEquals((long)3L, (long)ums.getAvailableMappings().size());
    }

    @Test
    public void testJavaContrib() throws Exception {
        DummyUser dm = new DummyUser("jchan", "Jacky", "Chan");
        UserMapperService ums = (UserMapperService)Framework.getService(UserMapperService.class);
        NuxeoPrincipal principal = ums.getOrCreateAndUpdateNuxeoPrincipal("javaDummy", (Object)dm);
        Assert.assertNotNull((Object)principal);
        Assert.assertEquals((Object)"jchan", (Object)principal.getName());
        Assert.assertEquals((Object)"Jacky", (Object)principal.getFirstName());
        Assert.assertEquals((Object)"Chan", (Object)principal.getLastName());
        dm = new DummyUser("jchan", null, "Chan2");
        principal = ums.getOrCreateAndUpdateNuxeoPrincipal("javaDummy", (Object)dm);
        Assert.assertNotNull((Object)principal);
        Assert.assertEquals((Object)"jchan", (Object)principal.getName());
        Assert.assertEquals((Object)"Jacky", (Object)principal.getFirstName());
        Assert.assertEquals((Object)"Chan2", (Object)principal.getLastName());
        TransactionHelper.runInTransaction(() -> {
            UserProfileService ups = (UserProfileService)Framework.getService(UserProfileService.class);
            DocumentModel profile = ups.getUserProfileDocument("jchan", this.session);
            Assert.assertEquals((Object)"555.666.7777", (Object)profile.getPropertyValue("userprofile:phonenumber"));
        });
    }

    @Test
    public void testJavaContribNoTransaction() throws Exception {
        TransactionHelper.commitOrRollbackTransaction();
        try {
            this.testJavaContrib();
        }
        finally {
            TransactionHelper.startTransaction();
        }
    }

    @Test
    public void testGroovyContrib() throws Exception {
        DummyUser dm = new DummyUser("bharper", "Ben", "Harper");
        UserMapperService ums = (UserMapperService)Framework.getService(UserMapperService.class);
        NuxeoPrincipal principal = ums.getOrCreateAndUpdateNuxeoPrincipal("groovyDummy", (Object)dm);
        Assert.assertNotNull((Object)principal);
        Assert.assertEquals((Object)"bharper", (Object)principal.getName());
        Assert.assertEquals((Object)"Ben", (Object)principal.getFirstName());
        Assert.assertEquals((Object)"Harper", (Object)principal.getLastName());
        dm = new DummyUser("bharper", "Bill", "Harper");
        principal = ums.getOrCreateAndUpdateNuxeoPrincipal("groovyDummy", (Object)dm);
        Assert.assertNotNull((Object)principal);
        Assert.assertEquals((Object)"bharper", (Object)principal.getName());
        Assert.assertEquals((Object)"Bill", (Object)principal.getFirstName());
        Assert.assertEquals((Object)"Harper", (Object)principal.getLastName());
        UserProfileService ups = (UserProfileService)Framework.getService(UserProfileService.class);
        DocumentModel profile = ups.getUserProfileDocument("bharper", this.session);
        Assert.assertEquals((Object)"555.666.7777", (Object)profile.getPropertyValue("userprofile:phonenumber"));
    }

    @Test
    public void testNashornContrib() throws Exception {
        DummyUser dm = new DummyUser("bharper", "Ben", "Harper");
        UserMapperService ums = (UserMapperService)Framework.getService(UserMapperService.class);
        NuxeoPrincipal principal = ums.getOrCreateAndUpdateNuxeoPrincipal("jsDummy", (Object)dm);
        Assert.assertNotNull((Object)principal);
        Assert.assertEquals((Object)"bharper", (Object)principal.getName());
        Assert.assertEquals((Object)"Ben", (Object)principal.getFirstName());
        Assert.assertEquals((Object)"Harper", (Object)principal.getLastName());
        dm = new DummyUser("bharper", "Bill", "Harper");
        principal = ums.getOrCreateAndUpdateNuxeoPrincipal("jsDummy", (Object)dm);
        Assert.assertNotNull((Object)principal);
        Assert.assertEquals((Object)"bharper", (Object)principal.getName());
        Assert.assertEquals((Object)"Bill", (Object)principal.getFirstName());
        Assert.assertEquals((Object)"Harper", (Object)principal.getLastName());
        UserProfileService ups = (UserProfileService)Framework.getService(UserProfileService.class);
        DocumentModel profile = ups.getUserProfileDocument("bharper", this.session);
        Assert.assertEquals((Object)"555.666.7777", (Object)profile.getPropertyValue("userprofile:phonenumber"));
    }
}

