/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webdav.resource;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.java.dev.webdav.core.jaxrs.xml.properties.IsCollection;
import net.java.dev.webdav.core.jaxrs.xml.properties.IsFolder;
import net.java.dev.webdav.core.jaxrs.xml.properties.IsHidden;
import net.java.dev.webdav.jaxrs.methods.PROPFIND;
import net.java.dev.webdav.jaxrs.xml.elements.HRef;
import net.java.dev.webdav.jaxrs.xml.elements.MultiStatus;
import net.java.dev.webdav.jaxrs.xml.elements.Prop;
import net.java.dev.webdav.jaxrs.xml.elements.PropFind;
import net.java.dev.webdav.jaxrs.xml.elements.PropStat;
import net.java.dev.webdav.jaxrs.xml.elements.Status;
import net.java.dev.webdav.jaxrs.xml.properties.CreationDate;
import net.java.dev.webdav.jaxrs.xml.properties.DisplayName;
import net.java.dev.webdav.jaxrs.xml.properties.GetContentLength;
import net.java.dev.webdav.jaxrs.xml.properties.GetContentType;
import net.java.dev.webdav.jaxrs.xml.properties.GetLastModified;
import net.java.dev.webdav.jaxrs.xml.properties.LockDiscovery;
import net.java.dev.webdav.jaxrs.xml.properties.ResourceType;
import net.java.dev.webdav.jaxrs.xml.properties.SupportedLock;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.webdav.Util;
import org.nuxeo.ecm.webdav.backend.WebDavBackend;
import org.nuxeo.ecm.webdav.resource.ExistingResource;
import org.nuxeo.ecm.webdav.resource.PropStatBuilderExt;

public class FolderResource
extends ExistingResource {
    private static final Log log = LogFactory.getLog(FolderResource.class);

    public FolderResource(String path, DocumentModel doc, HttpServletRequest request, WebDavBackend backend) throws Exception {
        super(path, doc, request, backend);
    }

    @GET
    @Produces(value={"text/html"})
    public String get() throws ClientException {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><p>Folder listing for " + this.path + ":</p>\n<ul>");
        List<DocumentModel> children = this.backend.getChildren(this.doc.getRef());
        for (DocumentModel child : children) {
            String childName = this.backend.getDisplayName(child);
            sb.append("<li><a href='" + childName + "'>" + childName + "</a></li>\n");
        }
        sb.append("</ul></body>\n");
        return sb.toString();
    }

    @PROPFIND
    public Response propfind(@Context UriInfo uriInfo, @HeaderParam(value="depth") String depth) throws Exception {
        if (depth == null) {
            depth = "1";
        }
        Unmarshaller u = Util.getUnmarshaller();
        Prop prop = null;
        if (this.request.getInputStream() != null && this.request.getContentLength() > 0) {
            PropFind propFind;
            try {
                propFind = (PropFind)u.unmarshal((InputStream)this.request.getInputStream());
            }
            catch (JAXBException e) {
                log.error((Object)e);
                return Response.status((int)400).build();
            }
            prop = propFind.getProp();
        }
        Date lastModified = this.getTimePropertyWrapper(this.doc, "dc:modified");
        Date creationDate = this.getTimePropertyWrapper(this.doc, "dc:created");
        net.java.dev.webdav.jaxrs.xml.elements.Response response = new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(uriInfo.getRequestUri()), null, null, null, new PropStat(new Prop(new Object[]{new DisplayName("nuxeo"), new LockDiscovery(), new SupportedLock(), new IsFolder("t"), new IsCollection(1), new IsHidden(0), new GetContentType("application/octet-stream"), new GetContentLength(0L), new CreationDate(creationDate), new GetLastModified(lastModified), ResourceType.COLLECTION}), new Status(Response.Status.OK)), new PropStat[0]);
        if (!this.doc.isFolder() || depth.equals("0")) {
            return Response.status((int)207).entity((Object)new MultiStatus(new net.java.dev.webdav.jaxrs.xml.elements.Response[]{response})).build();
        }
        ArrayList<net.java.dev.webdav.jaxrs.xml.elements.Response> responses = new ArrayList<net.java.dev.webdav.jaxrs.xml.elements.Response>();
        responses.add(response);
        List<DocumentModel> children = this.backend.getChildren(this.doc.getRef());
        for (DocumentModel child : children) {
            lastModified = this.getTimePropertyWrapper(child, "dc:modified");
            creationDate = this.getTimePropertyWrapper(child, "dc:created");
            String childName = URIUtil.encodePath((String)this.backend.getDisplayName(child));
            PropStatBuilderExt props = new PropStatBuilderExt();
            props.lastModified(lastModified).creationDate(creationDate).displayName(childName).status(Response.Status.OK);
            if (child.isFolder()) {
                props.isCollection();
            } else {
                Blob blob = (Blob)child.getPropertyValue("file:content");
                String mimeType = "application/octet-stream";
                long size = 0L;
                if (blob != null) {
                    size = blob.getLength();
                    mimeType = blob.getMimeType();
                }
                if (StringUtils.isEmpty((String)mimeType) || "???".equals(mimeType)) {
                    mimeType = "application/octet-stream";
                }
                props.isResource(size, mimeType);
            }
            PropStat found = props.build();
            PropStat notFound = null;
            if (prop != null) {
                notFound = props.notFound(prop);
            }
            URI childUri = uriInfo.getRequestUriBuilder().path(childName).build(new Object[0]);
            net.java.dev.webdav.jaxrs.xml.elements.Response childResponse = notFound != null ? new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(childUri), null, null, null, found, new PropStat[]{notFound}) : new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(childUri), null, null, null, found, new PropStat[0]);
            responses.add(childResponse);
        }
        MultiStatus st = new MultiStatus(responses.toArray(new net.java.dev.webdav.jaxrs.xml.elements.Response[responses.size()]));
        return Response.status((int)207).entity((Object)st).build();
    }
}

