/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webdav.resource;

import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.java.dev.webdav.jaxrs.methods.PROPFIND;
import net.java.dev.webdav.jaxrs.xml.elements.HRef;
import net.java.dev.webdav.jaxrs.xml.elements.MultiStatus;
import net.java.dev.webdav.jaxrs.xml.elements.Prop;
import net.java.dev.webdav.jaxrs.xml.elements.PropFind;
import net.java.dev.webdav.jaxrs.xml.elements.PropStat;
import net.java.dev.webdav.jaxrs.xml.elements.Status;
import net.java.dev.webdav.jaxrs.xml.properties.CreationDate;
import net.java.dev.webdav.jaxrs.xml.properties.GetContentLength;
import net.java.dev.webdav.jaxrs.xml.properties.GetContentType;
import net.java.dev.webdav.jaxrs.xml.properties.GetLastModified;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.webdav.Util;
import org.nuxeo.ecm.webdav.backend.WebDavBackend;
import org.nuxeo.ecm.webdav.resource.ExistingResource;
import org.nuxeo.runtime.services.streaming.InputStreamSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class FileResource
extends ExistingResource {
    private static final Log log = LogFactory.getLog(FileResource.class);

    public FileResource(String path, DocumentModel doc, HttpServletRequest request, WebDavBackend backend) throws Exception {
        super(path, doc, request, backend);
    }

    @GET
    public Object get() throws Exception {
        String mimeType;
        Blob content = (Blob)this.doc.getPropertyValue("file:content");
        if (content == null) {
            return Response.ok((Object)"").build();
        }
        try {
            mimeType = content.getMimeType();
        }
        catch (Exception e) {
            mimeType = "application/octet-stream";
        }
        if ("???".equals(mimeType)) {
            mimeType = "application/octet-stream";
        }
        return Response.ok((Object)content).type(mimeType).build();
    }

    @PUT
    public Response put() throws Exception {
        if (this.backend.isLocked(this.doc.getRef()) && !this.backend.canUnlock(this.doc.getRef())) {
            return Response.status((int)423).build();
        }
        try {
            StreamingBlob content = new StreamingBlob((StreamSource)new InputStreamSource((InputStream)this.request.getInputStream()));
            String contentType = this.request.getContentType();
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            content.setMimeType(contentType);
            content.setFilename(this.name);
            this.backend.updateDocument(this.doc, this.name, (Blob)content);
            return Response.created((URI)new URI(URLEncoder.encode(this.path, "UTF8"))).build();
        }
        catch (Exception e) {
            log.error((Object)"Error during PUT method execution", (Throwable)e);
            return Response.status((int)409).build();
        }
    }

    @PROPFIND
    public Response propfind(@Context UriInfo uriInfo) throws Exception {
        Unmarshaller u = Util.getUnmarshaller();
        if (this.request.getInputStream() != null && this.request.getContentLength() > 0) {
            PropFind propFind;
            try {
                propFind = (PropFind)u.unmarshal((InputStream)this.request.getInputStream());
            }
            catch (JAXBException e) {
                return Response.status((int)400).build();
            }
            Prop prop = propFind.getProp();
        }
        Date lastModified = this.getTimePropertyWrapper(this.doc, "dc:modified");
        Date creationDate = this.getTimePropertyWrapper(this.doc, "dc:created");
        Blob content = (Blob)this.doc.getPropertyValue("file:content");
        Long contentLength = content != null ? content.getLength() : 0L;
        net.java.dev.webdav.jaxrs.xml.elements.Response response = new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(uriInfo.getRequestUri()), null, null, null, new PropStat(new Prop(new Object[]{new CreationDate(creationDate), new GetLastModified(lastModified), new GetContentType("application/octet-stream"), new GetContentLength(contentLength.longValue())}), new Status(Response.Status.OK)), new PropStat[0]);
        MultiStatus st = new MultiStatus(new net.java.dev.webdav.jaxrs.xml.elements.Response[]{response});
        return Response.status((int)207).entity((Object)st).build();
    }
}

