/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webdav.backend;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webdav.backend.WebDavBackend;
import org.nuxeo.ecm.webdav.backend.WebDavBackendFactory;

public class Backend {
    protected static WebDavBackendFactory factoryWebDav = null;
    private static final Log log = LogFactory.getLog(WebDavBackendFactory.class);

    public static WebDavBackendFactory getFactory() {
        if (factoryWebDav == null) {
            factoryWebDav = Backend.loadFactory();
        }
        return factoryWebDav;
    }

    protected static synchronized WebDavBackendFactory loadFactory() {
        String factoryClass = "org.nuxeo.ecm.platform.wi.backend.webdav.WebDavBackendFactoryImpl";
        try {
            factoryWebDav = (WebDavBackendFactory)Class.forName(factoryClass, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Unable to create backend factoryWebDav", (Throwable)e);
        }
        return factoryWebDav;
    }

    public static WebDavBackend get(String path, HttpServletRequest request) {
        return Backend.getFactory().getBackend(path, request);
    }
}

