/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webdav.resource;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.java.dev.webdav.core.jaxrs.xml.properties.Win32CreationTime;
import net.java.dev.webdav.core.jaxrs.xml.properties.Win32FileAttributes;
import net.java.dev.webdav.core.jaxrs.xml.properties.Win32LastAccessTime;
import net.java.dev.webdav.core.jaxrs.xml.properties.Win32LastModifiedTime;
import net.java.dev.webdav.jaxrs.methods.COPY;
import net.java.dev.webdav.jaxrs.methods.LOCK;
import net.java.dev.webdav.jaxrs.methods.MKCOL;
import net.java.dev.webdav.jaxrs.methods.MOVE;
import net.java.dev.webdav.jaxrs.methods.PROPPATCH;
import net.java.dev.webdav.jaxrs.methods.UNLOCK;
import net.java.dev.webdav.jaxrs.xml.elements.ActiveLock;
import net.java.dev.webdav.jaxrs.xml.elements.Depth;
import net.java.dev.webdav.jaxrs.xml.elements.HRef;
import net.java.dev.webdav.jaxrs.xml.elements.LockRoot;
import net.java.dev.webdav.jaxrs.xml.elements.LockScope;
import net.java.dev.webdav.jaxrs.xml.elements.LockToken;
import net.java.dev.webdav.jaxrs.xml.elements.LockType;
import net.java.dev.webdav.jaxrs.xml.elements.MultiStatus;
import net.java.dev.webdav.jaxrs.xml.elements.Owner;
import net.java.dev.webdav.jaxrs.xml.elements.Prop;
import net.java.dev.webdav.jaxrs.xml.elements.PropStat;
import net.java.dev.webdav.jaxrs.xml.elements.Status;
import net.java.dev.webdav.jaxrs.xml.elements.TimeOut;
import net.java.dev.webdav.jaxrs.xml.properties.LockDiscovery;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.webdav.Util;
import org.nuxeo.ecm.webdav.backend.Backend;
import org.nuxeo.ecm.webdav.backend.WebDavBackend;
import org.nuxeo.ecm.webdav.resource.AbstractResource;
import org.nuxeo.ecm.webdav.resource.PropStatBuilderExt;

public class ExistingResource
extends AbstractResource {
    public static final String READONLY_TOKEN = "readonly";
    private static final Log log = LogFactory.getLog(ExistingResource.class);
    protected DocumentModel doc;
    protected WebDavBackend backend;

    protected ExistingResource(String path, DocumentModel doc, HttpServletRequest request, WebDavBackend backend) throws Exception {
        super(path, request);
        this.doc = doc;
        this.backend = backend;
    }

    @DELETE
    public Response delete() throws Exception {
        if (this.backend.isLocked(this.doc.getRef()) && !this.backend.canUnlock(this.doc.getRef())) {
            return Response.status((int)423).build();
        }
        try {
            this.backend.removeItem(this.doc.getRef());
            this.backend.saveChanges();
            return Response.status((int)204).build();
        }
        catch (ClientException e) {
            log.error((Object)("Can't remove item: " + this.doc.getPathAsString() + e.getMessage()));
            log.debug((Object)e);
            this.backend.discardChanges();
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
    }

    @COPY
    public Response copy(@HeaderParam(value="Destination") String dest, @HeaderParam(value="Overwrite") String overwrite) throws Exception {
        return this.copyOrMove("COPY", dest, overwrite);
    }

    @MOVE
    public Response move(@HeaderParam(value="Destination") String dest, @HeaderParam(value="Overwrite") String overwrite) throws Exception {
        if (this.backend.isLocked(this.doc.getRef()) && !this.backend.canUnlock(this.doc.getRef())) {
            return Response.status((int)423).build();
        }
        return this.copyOrMove("MOVE", dest, overwrite);
    }

    private Response copyOrMove(String method, @HeaderParam(value="Destination") String destination, @HeaderParam(value="Overwrite") String overwrite) throws Exception {
        String destPath;
        if (this.backend.isLocked(this.doc.getRef()) && !this.backend.canUnlock(this.doc.getRef())) {
            return Response.status((int)423).build();
        }
        destination = Util.encode(destination.getBytes(), "ISO-8859-1");
        destination = URIUtil.decode((String)destination);
        WebDavBackend root = Backend.get("/", this.request);
        HashSet<String> names = new HashSet<String>(root.getVirtualFolderNames());
        Path destinationPath = new Path(destination);
        String[] segments = destinationPath.segments();
        int removeSegments = 0;
        for (String segment : segments) {
            if (names.contains(segment)) break;
            ++removeSegments;
        }
        destinationPath = destinationPath.removeFirstSegments(removeSegments);
        String davDestPath = destPath = destinationPath.toString();
        WebDavBackend destinationBackend = Backend.get(davDestPath, this.request);
        destPath = destinationBackend.parseLocation(destPath).toString();
        log.debug((Object)("to " + davDestPath));
        int status = 201;
        if (destinationBackend.exists(davDestPath)) {
            if ("F".equals(overwrite)) {
                return Response.status((int)412).build();
            }
            destinationBackend.removeItem(davDestPath);
            status = 204;
        }
        String destParentPath = Util.getParentPath(destPath);
        PathRef destParentRef = new PathRef(destParentPath);
        if (!destinationBackend.exists(Util.getParentPath(davDestPath))) {
            return Response.status((int)409).build();
        }
        if ("COPY".equals(method)) {
            DocumentModel destDoc = this.backend.copyItem(this.doc, destParentRef);
            this.backend.renameItem(destDoc, Util.getNameFromPath(destPath));
        } else if ("MOVE".equals(method)) {
            if (this.backend.isRename(this.doc.getPathAsString(), destPath)) {
                this.backend.renameItem(this.doc, Util.getNameFromPath(destPath));
            } else {
                this.backend.moveItem(this.doc, destParentRef);
            }
        }
        this.backend.saveChanges();
        return Response.status((int)status).build();
    }

    @PROPPATCH
    public Response proppatch(@Context UriInfo uriInfo) throws Exception {
        if (this.backend.isLocked(this.doc.getRef()) && !this.backend.canUnlock(this.doc.getRef())) {
            return Response.status((int)423).build();
        }
        net.java.dev.webdav.jaxrs.xml.elements.Response response = new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(uriInfo.getRequestUri()), null, null, null, new PropStat(new Prop(new Object[]{new Win32CreationTime()}), new Status(Response.Status.OK)), new PropStat[]{new PropStat(new Prop(new Object[]{new Win32FileAttributes()}), new Status(Response.Status.OK)), new PropStat(new Prop(new Object[]{new Win32LastAccessTime()}), new Status(Response.Status.OK)), new PropStat(new Prop(new Object[]{new Win32LastModifiedTime()}), new Status(Response.Status.OK))});
        return Response.status((int)207).entity((Object)new MultiStatus(new net.java.dev.webdav.jaxrs.xml.elements.Response[]{response})).build();
    }

    @MKCOL
    public Response mkcol() {
        return Response.status((int)405).build();
    }

    @HEAD
    public Response head() {
        return Response.status((int)200).build();
    }

    @LOCK
    public Response lock(@Context UriInfo uriInfo) throws Exception {
        String token = null;
        Prop prop = null;
        if (this.backend.isLocked(this.doc.getRef())) {
            if (!this.backend.canUnlock(this.doc.getRef())) {
                return Response.status((int)423).build();
            }
            token = this.backend.getCheckoutUser(this.doc.getRef());
            prop = new Prop(new Object[]{this.getLockDiscovery(this.doc, uriInfo)});
            return Response.ok().entity((Object)prop).header("Lock-Token", (Object)("urn:uuid:" + token)).build();
        }
        token = this.backend.lock(this.doc.getRef());
        if (READONLY_TOKEN.equals(token)) {
            return Response.status((int)423).build();
        }
        if (StringUtils.isEmpty((String)token)) {
            return Response.status((int)400).build();
        }
        prop = new Prop(new Object[]{this.getLockDiscovery(this.doc, uriInfo)});
        this.backend.saveChanges();
        return Response.ok().entity((Object)prop).header("Lock-Token", (Object)("urn:uuid:" + token)).build();
    }

    @UNLOCK
    public Response unlock() throws Exception {
        if (this.backend.isLocked(this.doc.getRef())) {
            if (!this.backend.canUnlock(this.doc.getRef())) {
                return Response.status((int)423).build();
            }
            this.backend.unlock(this.doc.getRef());
            this.backend.saveChanges();
            return Response.status((int)204).build();
        }
        return Response.status((int)204).build();
    }

    protected LockDiscovery getLockDiscovery(DocumentModel doc, UriInfo uriInfo) throws ClientException {
        LockDiscovery lockDiscovery = null;
        if (doc.isLocked()) {
            String token = this.backend.getCheckoutUser(doc.getRef());
            lockDiscovery = new LockDiscovery(new ActiveLock[]{new ActiveLock(LockScope.EXCLUSIVE, LockType.WRITE, Depth.ZERO, new Owner(new Object[]{token}), new TimeOut(10000L), new LockToken(new HRef("urn:uuid:" + token)), new LockRoot(new HRef(uriInfo.getRequestUri())))});
        }
        return lockDiscovery;
    }

    protected PropStatBuilderExt getPropStatBuilderExt(DocumentModel doc, UriInfo uriInfo) throws ClientException, URIException {
        Date lastModified = this.getTimePropertyWrapper(doc, "dc:modified");
        Date creationDate = this.getTimePropertyWrapper(doc, "dc:created");
        String displayName = URIUtil.encodePath((String)this.backend.getDisplayName(doc));
        PropStatBuilderExt props = new PropStatBuilderExt();
        props.lastModified(lastModified).creationDate(creationDate).displayName(displayName).status(Response.Status.OK);
        if (doc.isFolder()) {
            props.isCollection();
        } else {
            String mimeType = "application/octet-stream";
            long size = 0L;
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (bh != null) {
                try {
                    Blob blob = bh.getBlob();
                    if (blob != null) {
                        size = blob.getLength();
                        mimeType = blob.getMimeType();
                    }
                }
                catch (ClientException e) {
                    log.error((Object)"Unable to get blob Size", (Throwable)e);
                }
            }
            if (StringUtils.isEmpty((String)mimeType) || "???".equals(mimeType)) {
                mimeType = "application/octet-stream";
            }
            props.isResource(size, mimeType);
        }
        return props;
    }

    protected Date getTimePropertyWrapper(DocumentModel doc, String name) {
        Serializable property;
        try {
            property = doc.getPropertyValue(name);
        }
        catch (ClientException e) {
            property = null;
            log.debug((Object)("Can't get property " + name + " from document " + doc.getId()));
        }
        if (property != null) {
            return ((Calendar)property).getTime();
        }
        return new Date();
    }
}

