/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.wss.WSSException;

public class CallRouter {
    protected static Map<String, Object> handlers = new HashMap<String, Object>();

    protected static <T> T getHandler(Class<T> handlerClass, String handlerName) throws WSSException {
        Object handler = handlers.get(handlerName);
        if (handler == null) {
            try {
                String pkg_prefix = handlerClass.getPackage().getName();
                Class<?> klass = Class.forName(pkg_prefix + "." + handlerName);
                handler = klass.newInstance();
                handlers.put(handlerName, handler);
            }
            catch (ReflectiveOperationException e) {
                throw new WSSException("Unable to find handler", e);
            }
        }
        return handlerClass.cast(handler);
    }
}

