/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.handlers.get;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wss.WSSConfig;
import org.nuxeo.wss.fprpc.FPRPCConts;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.servlet.WSSResponse;

public class SimpleGetHandler {
    private static final Log log = LogFactory.getLog(SimpleGetHandler.class);

    public void handleRequest(WSSRequest request, WSSResponse response) throws IOException {
        String uri = request.getHttpRequest().getRequestURI();
        String method = request.getHttpRequest().getMethod();
        String[] parts = uri.split("/");
        String lastSegment = parts[parts.length - 1];
        String UA = request.getHttpRequest().getHeader("User-Agent");
        log.debug((Object)("handling get request on uri = " + uri));
        if (FPRPCConts.MSOFFICE_USERAGENT.equals(UA)) {
            response.getHttpResponse().sendError(404);
            return;
        }
        if ("_vti_inf.html".equals(lastSegment)) {
            String prefix = "";
            if (!WSSConfig.instance().isHostFPExtensionAtRoot()) {
                prefix = WSSConfig.instance().getContextPath();
                if (prefix == null) {
                    prefix = "";
                } else if (!prefix.equals("")) {
                    if (!prefix.endsWith("/")) {
                        prefix = prefix + "/";
                    }
                    if (prefix.startsWith("/")) {
                        prefix = prefix.substring(1);
                    }
                }
            }
            response.addRenderingParameter("prefix", prefix);
            response.getHttpResponse().setHeader("Public-Extension", "http://schemas.microsoft.com/repl-2");
            response.setRenderingTemplateName(lastSegment);
        }
    }
}

