/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webdav.backend.Backend;
import org.nuxeo.ecm.webdav.backend.VirtualBackend;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.impl.NuxeoListItem;
import org.nuxeo.wss.impl.VirtualListItem;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.spi.AbstractWSSBackend;
import org.nuxeo.wss.spi.WSSListItem;
import org.nuxeo.wss.spi.dws.DWSMetaData;
import org.nuxeo.wss.spi.dws.DWSMetaDataImpl;
import org.nuxeo.wss.spi.dws.Site;
import org.nuxeo.wss.spi.dws.SiteImpl;
import org.nuxeo.wss.spi.dws.User;
import org.nuxeo.wss.spi.dws.UserImpl;

public class WSSBackendAdapter
extends AbstractWSSBackend {
    protected String corePathPrefix;
    protected String urlRoot;
    protected String virtualRoot;
    protected Backend backend;

    public WSSBackendAdapter(Backend backend, String virtualRoot) {
        this.backend = backend;
        this.corePathPrefix = backend.getRootPath();
        this.urlRoot = virtualRoot + "/" + backend.getRootUrl();
        this.virtualRoot = virtualRoot;
    }

    @Override
    public boolean exists(String location) {
        return this.backend.exists(this.cleanLocation(location));
    }

    @Override
    public WSSListItem getItem(String location) throws WSSException {
        location = this.cleanLocation(location);
        try {
            DocumentModel doc = this.backend.resolveLocation(location);
            if (doc != null) {
                return this.createItem(doc);
            }
            throw new WSSException("Unable to find item " + location);
        }
        catch (ClientException e) {
            throw new WSSException("Error while getting item", e);
        }
    }

    @Override
    public List<WSSListItem> listItems(String location) throws WSSException {
        location = this.cleanLocation(location);
        ArrayList<WSSListItem> result = new ArrayList<WSSListItem>();
        try {
            if (this.backend.isVirtual()) {
                LinkedList backendNames = ((VirtualBackend)this.backend).getOrderedBackendNames();
                for (String name : backendNames) {
                    result.add(this.createItem(name));
                }
            } else {
                DocumentModel parent = this.backend.resolveLocation(location);
                if (parent == null) {
                    throw new WSSException("Parent document with location " + location + " not found");
                }
                List children = this.backend.getChildren(parent.getRef());
                for (DocumentModel model : children) {
                    NuxeoListItem item = this.createItem(model);
                    result.add(item);
                }
            }
        }
        catch (ClientException e) {
            throw new WSSException("Error while getting children for " + location, e);
        }
        return result;
    }

    @Override
    public void begin() throws WSSException {
    }

    @Override
    public void saveChanges() throws WSSException {
        try {
            this.backend.saveChanges();
        }
        catch (ClientException e) {
            throw new WSSException("Error during save changes", e);
        }
    }

    @Override
    public WSSListItem moveItem(String location, String destination) throws WSSException {
        location = this.cleanLocation(location);
        destination = this.cleanLocation(destination);
        try {
            DocumentModel model = this.backend.resolveLocation(location);
            if (model == null) {
                throw new WSSException("Can't move document. Source did not found.");
            }
            Path destinationPath = this.backend.parseLocation(destination);
            DocumentModel doc = this.backend.moveItem(model, (DocumentRef)new PathRef(destinationPath.removeLastSegments(1).toString()), destinationPath.lastSegment());
            return this.createItem(doc);
        }
        catch (ClientException e) {
            throw new WSSException("Error during move document", e);
        }
    }

    public WSSListItem moveItem(DocumentModel model, String destination) throws WSSException {
        destination = this.cleanLocation(destination);
        try {
            if (model == null) {
                throw new WSSException("Can't move document. Source did not found.");
            }
            Path destinationPath = this.backend.parseLocation(destination);
            DocumentModel doc = this.backend.moveItem(model, (DocumentRef)new PathRef(destinationPath.removeLastSegments(1).toString()), destinationPath.lastSegment());
            return this.createItem(doc);
        }
        catch (ClientException e) {
            throw new WSSException("Error during move document", e);
        }
    }

    public DocumentModel getDocument(String location) throws WSSException {
        location = this.cleanLocation(location);
        try {
            return this.backend.resolveLocation(location);
        }
        catch (ClientException e) {
            throw new WSSException("Error during get document " + location);
        }
    }

    @Override
    public void removeItem(String location) throws WSSException {
        location = this.cleanLocation(location);
        try {
            this.backend.removeItem(location);
        }
        catch (ClientException e) {
            throw new WSSException("Error while deleting doc. Location:" + location, e);
        }
    }

    @Override
    public WSSListItem createFolder(String parentPath, String name) throws WSSException {
        parentPath = this.cleanLocation(parentPath);
        try {
            DocumentModel model = this.backend.createFolder(parentPath, name);
            return this.createItem(model);
        }
        catch (ClientException e) {
            throw new WSSException("Error child creating new folder", e);
        }
    }

    @Override
    public WSSListItem createFileItem(String parentPath, String name) throws WSSException {
        parentPath = this.cleanLocation(parentPath);
        try {
            DocumentModel model = this.backend.createFile(parentPath, name);
            return this.createItem(model);
        }
        catch (ClientException e) {
            throw new WSSException("Error child creating new file", e);
        }
    }

    @Override
    public DWSMetaData getMetaData(String location, WSSRequest wssRequest) throws WSSException {
        location = this.cleanLocation(location);
        try {
            DWSMetaDataImpl metadata = new DWSMetaDataImpl();
            String parentPath = new Path(location).removeLastSegments(1).toString();
            List<WSSListItem> documents = this.listItems(parentPath);
            metadata.setDocuments(documents);
            metadata.setSite(this.getSite(location));
            String cUserName = this.backend.getSession().getPrincipal().getName();
            ArrayList<Object> userNames = new ArrayList<Object>();
            for (WSSListItem item : documents) {
                String[] contributors;
                if (item.getAuthor() != null && !userNames.contains(item.getAuthor())) {
                    userNames.add(item.getAuthor());
                }
                if ((contributors = (String[])((NuxeoListItem)item).getDoc().getPropertyValue("dc:contributors")) == null) continue;
                for (String contributor : contributors) {
                    if (userNames.contains(contributor)) continue;
                    userNames.add(contributor);
                }
            }
            User currentUser = this.getUserFromLogin(cUserName, 1);
            metadata.setCurrentUser(currentUser);
            ArrayList<User> users = new ArrayList<User>();
            users.add(currentUser);
            int i = 2;
            for (String string : userNames) {
                if (string.equals(cUserName)) continue;
                users.add(this.getUserFromLogin(string, i));
                ++i;
            }
            metadata.setUsers(users);
            return metadata;
        }
        catch (ClientException e) {
            throw new WSSException("Error in getMetadata", e);
        }
    }

    @Override
    public Site getSite(String location) throws WSSException {
        String parentPath = new Path(location).removeLastSegments(1).toString();
        NuxeoListItem parent = (NuxeoListItem)this.getItem(parentPath);
        String siteName = parent.getDisplayName();
        SiteImpl site = new SiteImpl(siteName);
        String nxUrl = this.urlRoot + "/nxpath/default" + parent.getDoc().getPathAsString() + "@view_documents";
        try {
            site.setAccessUrl("?org.nuxeo.wss.forwardedFilter=" + URLEncoder.encode(nxUrl, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new WSSException("Error encoding url", e);
        }
        site.setUserManagementUrl("");
        site.setListUUID(parent.getEtag());
        site.setItem(parent);
        return site;
    }

    private NuxeoListItem createItem(DocumentModel model) {
        return new NuxeoListItem(model, this.corePathPrefix, this.urlRoot);
    }

    private VirtualListItem createItem(String name) {
        return new VirtualListItem(name, this.corePathPrefix, this.urlRoot);
    }

    protected User getUserFromLogin(String userLogin, int idx) {
        UserImpl user = null;
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        NuxeoPrincipal principal = um.getPrincipal(userLogin);
        if (principal != null) {
            String email = (String)principal.getModel().getProperty(um.getUserSchemaName(), um.getUserEmailField());
            String fullname = principal.getFirstName() + " " + principal.getLastName();
            if (fullname.equals(" ")) {
                fullname = userLogin;
            }
            user = new UserImpl("" + idx, userLogin, fullname, email);
        } else {
            user = new UserImpl("" + idx, userLogin, userLogin, "");
        }
        return user;
    }

    protected String cleanLocation(String location) {
        if ((location = this.cleanPath(location)).startsWith(this.virtualRoot)) {
            location = location.substring(this.virtualRoot.length());
        }
        return location;
    }

    protected String cleanPath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }
}

