/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FailSafeWSSFilter
implements Filter {
    protected Filter wssFilter;
    protected Log log = LogFactory.getLog(FailSafeWSSFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            Class.forName("org.nuxeo.wss.servlet.BaseWSSFilter");
            Class<?> filterklass = Class.forName("org.nuxeo.wss.servlet.WSSFilter");
            this.wssFilter = (Filter)filterklass.newInstance();
            this.wssFilter.init(filterConfig);
        }
        catch (ReflectiveOperationException t) {
            this.log.warn((Object)"Can not initialize WSS Stack, check your installation : WSS feature won't be available", (Throwable)t);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.wssFilter != null) {
            this.wssFilter.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        if (this.wssFilter != null) {
            this.wssFilter.destroy();
        }
    }
}

