/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.web;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRowDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetReference;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskImpl;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.action.ActionContextProvider;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="routingTaskActions")
public class RoutingTaskActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RoutingTaskActionsBean.class);
    public static final String SUBJECT_PATTERN = "([a-zA-Z_0-9]*(:)[a-zA-Z_0-9]*)";
    public static final String CACHE_ACTIONS_PER_TASK_TYPE_PROP_NAME = "org.nuxeo.routing.cacheActionsPerTaskType";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(required=true, create=true)
    protected NavigationContext navigationContext;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true, required=false)
    protected transient ActionContextProvider actionContextProvider;
    @In(create=true, required=false)
    protected ContentViewActions contentViewActions;
    @RequestParameter(value="button")
    protected String button;
    protected ActionManager actionService;
    protected Map<String, TaskInfo> tasksInfoCache = new HashMap<String, TaskInfo>();
    protected Task currentTask;
    protected List<String> formVariablesToKeep;

    public void validateTaskDueDate(FacesContext context, UIComponent component, Object value) {
        String DATE_FORMAT = "dd/MM/yyyy";
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        String messageString = null;
        if (value != null) {
            try {
                Date dueDate = dateFormat.parse(dateFormat.format((Date)value));
                Date today = dateFormat.parse(dateFormat.format(new Date()));
                if (dueDate.before(today)) {
                    messageString = "label.workflow.error.outdated_duedate";
                }
            }
            catch (ParseException e) {
                messageString = "label.workflow.error.date_parsing";
            }
        }
        if (messageString != null) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.workflow.error.outdated_duedate"), null);
            ((EditableValueHolder)component).setValid(false);
            context.addMessage(component.getClientId(context), message);
        }
    }

    public void validateSubject(FacesContext context, UIComponent component, Object value) {
        if (!(value instanceof String) || !((String)value).matches(SUBJECT_PATTERN)) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.document.routing.invalid.subject"), null);
            context.addMessage(null, message);
            throw new ValidatorException(message);
        }
    }

    public String getTaskLayout(Task task) {
        return this.getTaskInfo((Task)task, (boolean)true).layout;
    }

    public List<Action> getTaskButtons(Task task) {
        List<GraphNode.Button> buttons = this.getTaskInfo((Task)task, (boolean)true).buttons;
        ArrayList<Action> actions = new ArrayList<Action>();
        DocumentModel workflowInstance = this.documentManager.getDocument((DocumentRef)new IdRef(task.getProcessId()));
        GraphRoute workflow = (GraphRoute)workflowInstance.getAdapter(GraphRoute.class);
        if (workflow == null) {
            return actions;
        }
        GraphNode node = workflow.getNode(task.getType());
        for (GraphNode.Button button : buttons) {
            Action action = new Action(button.getName(), Action.EMPTY_CATEGORIES);
            action.setLabel(button.getLabel());
            action.setImmediate(button.getValidate() == false);
            boolean displayAction = true;
            if (StringUtils.isNotEmpty((CharSequence)button.getFilter())) {
                ActionContext actionContext = this.actionContextProvider.createActionContext();
                if (node != null) {
                    HashMap workflowContextualInfo = new HashMap();
                    workflowContextualInfo.putAll(node.getWorkflowContextualInfo(this.documentManager, true));
                    actionContext.putAllLocalVariables(workflowContextualInfo);
                }
                displayAction = this.getActionService().checkFilter(button.filter, actionContext);
            }
            if (!displayAction) continue;
            actions.add(action);
        }
        return actions;
    }

    public String endTask(Task task) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Map<String, Serializable> formVariables = this.getFormVariables(task);
        if (this.getFormVariables(task) != null) {
            data.put("WorkflowVariables", this.getFormVariables(task));
            data.put("NodeVariables", this.getFormVariables(task));
            if (formVariables.containsKey("comment")) {
                data.put("comment", formVariables.get("comment"));
            }
        }
        try {
            DocumentRoutingService routing = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
            routing.endTask(this.documentManager, task, data, this.button);
            this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("workflow.feedback.info.taskEnded"), new Object[0]);
        }
        catch (DocumentRouteException e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("workflow.feedback.error.taskEnded"), new Object[0]);
        }
        Events.instance().raiseEvent("workflowTaskCompleted", new Object[0]);
        this.clear(task.getId());
        if (this.navigationContext.getCurrentDocument() != null && this.documentManager.hasPermission(this.navigationContext.getCurrentDocument().getRef(), "Read")) {
            return null;
        }
        this.navigationContext.setCurrentDocument(null);
        return this.navigationContext.goHome();
    }

    private void clear(String taskId) {
        this.button = null;
        if (this.tasksInfoCache.containsKey(taskId)) {
            this.tasksInfoCache.remove(taskId);
        }
    }

    public Map<String, Serializable> getFormVariables(Task task) {
        return this.getTaskInfo((Task)task, (boolean)true).formVariables;
    }

    public TaskInfo getTaskInfo(final Task task, final boolean getFormVariables) {
        if (this.tasksInfoCache.containsKey(task.getId())) {
            return this.tasksInfoCache.get(task.getId());
        }
        final String routeDocId = task.getVariable("routeInstanceDocId");
        final String nodeId = task.getVariable("nodeId");
        if (routeDocId == null) {
            throw new NuxeoException("Can not get the source graph for this task");
        }
        if (nodeId == null) {
            throw new NuxeoException("Can not get the source node for this task");
        }
        final TaskInfo[] res = new TaskInfo[1];
        new UnrestrictedSessionRunner(this.documentManager){

            public void run() {
                DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(routeDocId));
                GraphRoute route = (GraphRoute)doc.getAdapter(GraphRoute.class);
                GraphNode node = route.getNode(nodeId);
                HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                if (getFormVariables) {
                    map.putAll(node.getVariables());
                    map.putAll(route.getVariables());
                }
                res[0] = new TaskInfo(task.getId(), map, node.getTaskLayout(), node.getTaskButtons(), node.allowTaskReassignment(), task.getName());
            }
        }.runUnrestricted();
        if (getFormVariables) {
            this.tasksInfoCache.put(task.getId(), res[0]);
        }
        return res[0];
    }

    public boolean isRoutingTask(Task task) {
        return task.getDocument().hasFacet("RoutingTask");
    }

    public List<Action> getTaskActions(Task task) {
        return new ArrayList<Action>(this.getTaskActionsMap(task).values());
    }

    protected boolean isLayoutEmpty(String layoutName) {
        if (layoutName == null || layoutName.isEmpty()) {
            return true;
        }
        WebLayoutManager lm = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        LayoutDefinition layout = lm.getLayoutDefinition(layoutName);
        return layout == null || layout.isEmpty();
    }

    protected String getTaskActionId(Task task, String buttonId) {
        return String.format("%s_%s", task.getType(), buttonId);
    }

    public Map<String, Action> getTaskActionsMap(Task task) {
        LinkedHashMap<String, Action> actions = new LinkedHashMap<String, Action>();
        TaskInfo taskInfo = this.getTaskInfo(task, true);
        String layout = taskInfo.layout;
        List<GraphNode.Button> buttons = taskInfo.buttons;
        boolean addLayout = !this.isLayoutEmpty(layout);
        HashMap<String, Object> props = null;
        if (addLayout) {
            props = new HashMap<String, Object>();
            props.put("layout", layout);
            props.put("formVariables", taskInfo.formVariables);
        }
        if (buttons != null && !buttons.isEmpty()) {
            for (GraphNode.Button button : buttons) {
                String buttonId = button.getName();
                String id = this.getTaskActionId(task, buttonId);
                Action action = new Action(id, Action.EMPTY_CATEGORIES);
                action.setLabel(button.getLabel());
                HashMap<String, Object> actionProps = new HashMap<String, Object>();
                actionProps.put("buttonId", buttonId);
                if (addLayout) {
                    actionProps.putAll(props);
                    action.setProperties(actionProps);
                    action.setType("fancybox");
                } else {
                    action.setProperties(actionProps);
                    action.setType("link");
                }
                boolean displayAction = true;
                if (StringUtils.isNotEmpty((CharSequence)button.getFilter())) {
                    displayAction = this.getActionService().checkFilter(button.filter, this.actionContextProvider.createActionContext());
                }
                if (!displayAction) continue;
                actions.put(id, action);
            }
        }
        if (addLayout && !actions.isEmpty()) {
            String id = this.getTaskActionId(task, "process_task");
            Action processAction = new Action(id, Action.EMPTY_CATEGORIES);
            this.formVariablesToKeep = new ArrayList<String>();
            WebLayoutManager layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
            LayoutDefinition taskLayout = layoutService.getLayoutDefinition(taskInfo.layout);
            if (taskLayout != null) {
                for (LayoutRowDefinition row : taskLayout.getRows()) {
                    for (WidgetReference widgetRef : row.getWidgetReferences()) {
                        WidgetDefinition widgetDefinition = taskLayout.getWidgetDefinition(widgetRef.getName());
                        if (widgetDefinition == null) continue;
                        String mode = widgetDefinition.getMode("edit");
                        ELActionContext el = new ELActionContext();
                        el.setCurrentPrincipal(this.documentManager.getPrincipal());
                        el.setCurrentDocument(this.navigationContext.getCurrentDocument());
                        mode = (String)el.evalExpression(mode, String.class);
                        if (mode != null && !mode.equals("edit")) continue;
                        Arrays.stream(widgetDefinition.getFieldDefinitions()).forEach(field -> {
                            String fieldName = field.getFieldName().replaceAll("^\\['|']$", "");
                            this.formVariablesToKeep.add(fieldName);
                        });
                    }
                }
            }
            processAction.setProperties(props);
            processAction.setType("process_task");
            actions.put(id, processAction);
        }
        return actions;
    }

    public List<Action> getTaskActions(String selectionListName) {
        LinkedHashMap actions = new LinkedHashMap();
        LinkedHashMap<String, Map> actionsPerTaskType = new LinkedHashMap<String, Map>();
        HashMap<String, Integer> actionsCounter = new HashMap<String, Integer>();
        List docs = this.documentsListsManager.getWorkingList(selectionListName);
        boolean cachePerType = Boolean.TRUE.equals(Boolean.valueOf(Framework.getProperty((String)CACHE_ACTIONS_PER_TASK_TYPE_PROP_NAME)));
        int taskDocsNum = 0;
        if (docs != null && !docs.isEmpty()) {
            for (DocumentModel doc : docs) {
                if (!doc.hasFacet("RoutingTask")) continue;
                TaskImpl task = new TaskImpl(doc);
                String taskType = task.getType();
                Map taskActions = Collections.emptyMap();
                if (cachePerType) {
                    if (actionsPerTaskType.containsKey(taskType)) {
                        taskActions = (Map)actionsPerTaskType.get(taskType);
                    } else {
                        taskActions = this.getTaskActionsMap((Task)task);
                        actionsPerTaskType.put(taskType, taskActions);
                    }
                } else {
                    taskActions = this.getTaskActionsMap((Task)task);
                    actions.putAll(taskActions);
                }
                for (String string : taskActions.keySet()) {
                    Integer count = (Integer)actionsCounter.get(string);
                    if (count == null) {
                        actionsCounter.put(string, 1);
                        continue;
                    }
                    actionsCounter.put(string, count + 1);
                }
                ++taskDocsNum;
            }
        }
        if (cachePerType) {
            for (Map actionsPerType : actionsPerTaskType.values()) {
                actions.putAll(actionsPerType);
            }
        }
        ArrayList<Action> res = new ArrayList<Action>(actions.values());
        for (Action action : res) {
            if (((Integer)actionsCounter.get(action.getId())).equals(taskDocsNum)) continue;
            action.setAvailable(false);
        }
        return res;
    }

    public String endTasks(String selectionListName, Action taskAction) {
        HashMap data = new HashMap();
        String buttonId = (String)taskAction.getProperties().get("buttonId");
        Map formVariables = (Map)taskAction.getProperties().get("formVariables");
        if (formVariables != null && !formVariables.isEmpty() && formVariables.containsKey("comment")) {
            data.put("comment", formVariables.get("comment"));
        }
        boolean hasErrors = false;
        DocumentRoutingService routing = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        List docs = this.documentsListsManager.getWorkingList(selectionListName);
        if (docs != null && !docs.isEmpty()) {
            for (DocumentModel doc : docs) {
                TaskImpl task = new TaskImpl(doc);
                Map<String, Serializable> variables = this.getFormVariables((Task)task);
                for (String fieldName : this.formVariablesToKeep) {
                    variables.put(fieldName, (Serializable)formVariables.get(fieldName));
                }
                data.put("WorkflowVariables", variables);
                data.put("NodeVariables", variables);
                if (!doc.hasFacet("RoutingTask")) continue;
                try {
                    routing.endTask(this.documentManager, (Task)new TaskImpl(doc), data, buttonId);
                }
                catch (DocumentRouteException e) {
                    log.error((Object)e, (Throwable)e);
                    hasErrors = true;
                }
            }
            this.formVariablesToKeep = null;
        }
        if (hasErrors) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("workflow.feedback.error.tasksEnded"), new Object[0]);
        } else {
            this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("workflow.feedback.info.tasksEnded"), new Object[0]);
        }
        this.documentsListsManager.resetWorkingList(selectionListName);
        Events.instance().raiseEvent("documentChanged", new Object[0]);
        Events.instance().raiseEvent("workflowTaskCompleted", new Object[0]);
        return null;
    }

    private ActionManager getActionService() {
        if (this.actionService == null) {
            this.actionService = (ActionManager)Framework.getService(ActionManager.class);
        }
        return this.actionService;
    }

    @Observer(value={"workflowTaskCompleted", "workflowTaskReassigned", "workflowTaskDelegated"})
    @BypassInterceptors
    public void OnTaskCompleted() {
        if (this.contentViewActions != null) {
            this.contentViewActions.refreshOnSeamEvent("workflowTaskCompleted");
            this.contentViewActions.resetPageProviderOnSeamEvent("workflowTaskCompleted");
        }
        this.tasksInfoCache.clear();
        this.currentTask = null;
    }

    public String reassignTask(TaskInfo taskInfo) {
        try {
            ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).reassignTask(this.documentManager, taskInfo.getTaskId(), taskInfo.getActors(), taskInfo.getComment());
            Events.instance().raiseEvent("workflowTaskReassigned", new Object[0]);
        }
        catch (DocumentRouteException e) {
            log.error((Object)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("workflow.feedback.error.taskEnded"), new Object[0]);
        }
        return null;
    }

    public String getWorkflowTitle(String instanceId) {
        String workflowTitle = "";
        try {
            DocumentModel routeInstance = this.documentManager.getDocument((DocumentRef)new IdRef(instanceId));
            workflowTitle = routeInstance.getTitle();
        }
        catch (DocumentNotFoundException e) {
            log.error((Object)("Can not fetch route instance with id " + instanceId), (Throwable)e);
        }
        return workflowTitle;
    }

    public String delegateTask(TaskInfo taskInfo) {
        try {
            ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).delegateTask(this.documentManager, taskInfo.getTaskId(), taskInfo.getActors(), taskInfo.getComment());
            Events.instance().raiseEvent("workflowTaskDelegated", new Object[0]);
        }
        catch (DocumentRouteException e) {
            log.error((Object)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("workflow.feedback.error.taskEnded"), new Object[0]);
        }
        return null;
    }

    public String navigateToTask(DocumentModel taskDoc) {
        this.setCurrentTask((Task)taskDoc.getAdapter(Task.class));
        return null;
    }

    public String navigateToTasksView() {
        this.setCurrentTask(null);
        return null;
    }

    public Task getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(Task currentTask) {
        this.currentTask = currentTask;
    }

    public List<String> getCurrentTaskTargetDocumentsIds() {
        HashSet uniqueTargetDocIds = new HashSet();
        ArrayList<String> docIds = new ArrayList<String>();
        if (this.currentTask == null) {
            return docIds;
        }
        uniqueTargetDocIds.addAll(this.currentTask.getTargetDocumentsIds());
        docIds.addAll(uniqueTargetDocIds);
        return docIds.isEmpty() ? null : docIds;
    }

    public boolean canBeReassign() {
        if (this.currentTask == null) {
            return false;
        }
        DocumentModel workflowInstance = this.documentManager.getDocument((DocumentRef)new IdRef(this.currentTask.getProcessId()));
        GraphRoute workflow = (GraphRoute)workflowInstance.getAdapter(GraphRoute.class);
        if (workflow == null) {
            return false;
        }
        GraphNode node = workflow.getNode(this.currentTask.getType());
        return node.allowTaskReassignment() && !this.currentTask.getDelegatedActors().contains(this.documentManager.getPrincipal().getName());
    }

    public class TaskInfo {
        protected HashMap<String, Serializable> formVariables;
        protected String layout;
        protected boolean canBeReassigned;
        protected List<GraphNode.Button> buttons;
        protected List<String> actors;
        protected String comment;
        protected String taskId;
        protected String name;

        protected TaskInfo(String taskId, HashMap<String, Serializable> formVariables, String layout, List<GraphNode.Button> buttons, boolean canBeReassigned, String name) {
            this.formVariables = formVariables;
            this.layout = layout;
            this.buttons = buttons;
            this.canBeReassigned = canBeReassigned;
            this.taskId = taskId;
            this.name = name;
        }

        public List<String> getActors() {
            return this.actors;
        }

        public void setActors(List<String> actors) {
            this.actors = actors;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public boolean isCanBeReassigned() {
            return this.canBeReassigned;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public String getName() {
            return this.name;
        }
    }
}

