/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.searchcenter.helper;

import java.security.Principal;
import java.util.List;
import java.util.Locale;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.searchcenter.model.FilterSet;
import org.nuxeo.ecm.searchcenter.service.SearchCenterService;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.runtime.api.Framework;

public class SearchCenterHelper {
    private static final Log log = LogFactory.getLog(SearchCenterHelper.class);

    private SearchCenterHelper() {
    }

    public static JSONArray execQuery(CoreSession session, String filterSetStr, String baseUrl) {
        FilterSet filterSet = FilterSet.fromJSON(filterSetStr);
        JSONArray results = new JSONArray();
        try {
            SearchCenterService searchCenterService = (SearchCenterService)Framework.getService(SearchCenterService.class);
            DocumentModelList docs = searchCenterService.execQuery(session, filterSet);
            for (DocumentModel doc : docs) {
                JSONObject obj = new JSONObject();
                obj.put((Object)"id", (Object)doc.getId());
                obj.put((Object)"head", (Object)searchCenterService.getResultHead(doc));
                obj.put((Object)"body", (Object)searchCenterService.getResultBody(doc));
                String url = searchCenterService.getUrlFor(baseUrl, "navigate", doc);
                obj.put((Object)"url", (Object)url);
                String preview = searchCenterService.getUrlFor(baseUrl, "preview", doc);
                obj.put((Object)"preview", (Object)preview);
                results.add((Object)obj);
            }
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
        return results;
    }

    public static JSONObject saveFilterSet(CoreSession session, Principal principal, String filterSetStr, String title) {
        FilterSet filterSet = FilterSet.fromJSON(filterSetStr);
        JSONObject result = new JSONObject();
        try {
            SearchCenterService searhCenterService = (SearchCenterService)Framework.getService(SearchCenterService.class);
            String id = searhCenterService.saveFilterSet(session, principal, filterSet, title);
            result.put((Object)"id", (Object)id);
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
        return result;
    }

    public static JSONArray getFilterSets(CoreSession session, Principal principal) {
        JSONArray results = new JSONArray();
        try {
            SearchCenterService searchCenterService = (SearchCenterService)Framework.getService(SearchCenterService.class);
            List<FilterSet> filterSets = searchCenterService.getFilterSets(session, principal);
            for (FilterSet filterSet : filterSets) {
                JSONObject result = new JSONObject();
                result.put((Object)"title", (Object)filterSet.getTitle());
                if (filterSet.getId() != null) {
                    result.put((Object)"id", (Object)filterSet.getId());
                    result.put((Object)"saved", (Object)true);
                } else {
                    result.put((Object)"id", (Object)filterSet.getName());
                    result.put((Object)"saved", (Object)false);
                }
                results.add((Object)result);
            }
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
        return results;
    }

    public static JSONObject getDefaultFilterSet(Locale locale) {
        JSONObject result;
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        try {
            SearchCenterService searhCenterService = (SearchCenterService)Framework.getService(SearchCenterService.class);
            FilterSet filterSet = searhCenterService.getDefaultFilterSet();
            result = filterSet.toJSON(locale);
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
        return result;
    }

    public static JSONObject getFilterSet(CoreSession session, String id, Locale locale) {
        JSONObject result;
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        try {
            SearchCenterService searhCenterService = (SearchCenterService)Framework.getService(SearchCenterService.class);
            FilterSet filterSet = searhCenterService.getFilterSet(session, id);
            result = filterSet.toJSON(locale);
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getVocabulary(String vocabularyName) {
        try {
            JSONArray list = new JSONArray();
            DirectoryService dService = (DirectoryService)Framework.getService(DirectoryService.class);
            Session session = dService.open(vocabularyName);
            try {
                DocumentModelList docs = session.getEntries();
                for (DocumentModel doc : docs) {
                    JSONObject obj = new JSONObject();
                    log.info((Object)("Available datamodels: " + StringUtils.join((Object[])doc.getDeclaredSchemas(), (String)",")));
                    DataModel dm = doc.getDataModel("vocabulary");
                    obj.put((Object)"id", dm.getData("id"));
                    obj.put((Object)"title", dm.getData("label"));
                    list.add((Object)obj);
                }
            }
            finally {
                session.close();
            }
            return list;
        }
        catch (Exception e) {
            throw WebException.wrap((String)("Failed to export vocabulary '" + vocabularyName + "' as json: "), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getHierarchicalVocabulary(String vocabularyName) {
        String voca = "";
        String subVoca = "";
        if ("topic".equals(vocabularyName)) {
            voca = "topic";
            subVoca = "subtopic";
            return SearchCenterHelper.getHierarchicalVocabulary(voca, subVoca);
        }
        if ("continent".equals(vocabularyName)) {
            voca = "continent";
            subVoca = "country";
            return SearchCenterHelper.getHierarchicalVocabulary(voca, subVoca);
        }
        try {
            JSONArray list = new JSONArray();
            DirectoryService dService = (DirectoryService)Framework.getService(DirectoryService.class);
            Session dSession = dService.open(vocabularyName);
            try {
                DocumentModelList entries = dSession.getEntries();
                for (DocumentModel doc : entries) {
                    JSONObject o = new JSONObject();
                    DataModel dm = doc.getDataModel("xvocabulary");
                    o.put((Object)"id", dm.getData("id"));
                    o.put((Object)"parent", dm.getData("parent"));
                    o.put((Object)"title", dm.getData("label"));
                    list.add((Object)o);
                }
            }
            finally {
                dSession.close();
            }
            return list;
        }
        catch (Exception e) {
            throw WebException.wrap((String)("Failed to export vocabulary '" + vocabularyName + "' as json: "), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONArray getHierarchicalVocabulary(String vocabularyName, String subVocabularyName) {
        try {
            JSONArray list = new JSONArray();
            DirectoryService dService = (DirectoryService)Framework.getService(DirectoryService.class);
            Session topicSession = dService.open(vocabularyName);
            Session subtopicSession = dService.open(subVocabularyName);
            try {
                DataModel dm;
                JSONObject obj;
                DocumentModelList topics = topicSession.getEntries();
                DocumentModelList subtopics = subtopicSession.getEntries();
                for (DocumentModel topic : topics) {
                    obj = new JSONObject();
                    dm = topic.getDataModel("vocabulary");
                    obj.put((Object)"id", dm.getData("id"));
                    obj.put((Object)"title", dm.getData("label"));
                    list.add((Object)obj);
                }
                for (DocumentModel subtopic : subtopics) {
                    obj = new JSONObject();
                    dm = subtopic.getDataModel("xvocabulary");
                    obj.put((Object)"id", dm.getData("id"));
                    obj.put((Object)"title", dm.getData("label"));
                    obj.put((Object)"parent", dm.getData("parent"));
                    list.add((Object)obj);
                }
            }
            finally {
                topicSession.close();
                subtopicSession.close();
            }
            return list;
        }
        catch (Exception e) {
            throw WebException.wrap((String)("Failed to export vocabulary '" + vocabularyName + "' as json: "), (Throwable)e);
        }
    }
}

