/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.searchcenter.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.searchcenter.model.FilterSetItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterSet {
    protected String title;
    protected String name;
    protected String id;
    protected List<FilterSetItem> items;

    public FilterSet(String title, String name, String id, List<FilterSetItem> items) {
        this.title = title;
        this.name = name;
        this.id = id;
        this.items = items;
    }

    public static FilterSet fromJSON(String jsonString) {
        JSONObject obj = JSONObject.fromObject((Object)jsonString);
        String title = obj.getString("title");
        String name = (String)obj.get("name");
        String id = (String)obj.get("id");
        ArrayList<FilterSetItem> items = new ArrayList<FilterSetItem>();
        JSONArray jsonItems = obj.getJSONArray("items");
        for (int i = 0; i < jsonItems.size(); ++i) {
            items.add(FilterSetItem.fromJSON(jsonItems.getJSONObject(i)));
        }
        return new FilterSet(title, name, id, items);
    }

    public JSONObject toJSON(Locale locale) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"title", (Object)this.title);
        obj.put((Object)"name", (Object)this.name);
        obj.put((Object)"id", (Object)this.id);
        JSONArray jsonItems = new JSONArray();
        for (FilterSetItem item : this.items) {
            jsonItems.add((Object)item.toJSON(locale));
        }
        obj.put((Object)"items", (Object)jsonItems);
        return obj;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<FilterSetItem> getItems() {
        return this.items;
    }

    public void setItems(List<FilterSetItem> items) {
        this.items = items;
    }
}

