/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.searchcenter.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.searchcenter.service.FilterWidgetDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterSetItem
extends HashMap<String, Object> {
    private static final long serialVersionUID = -2515914379625109575L;
    private static final Log log = LogFactory.getLog(FilterSetItem.class);
    protected static final DateFormat dateFormat = new SimpleDateFormat("M/d/yyyy");

    public FilterSetItem() {
    }

    public FilterSetItem(Map<String, Object> map) {
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value == null) continue;
            this.put(key, value);
        }
    }

    public FilterSetItem(FilterWidgetDescriptor descriptor, Boolean hidden) {
        this.put("name", descriptor.getName());
        this.put("index", descriptor.getIndex());
        this.put("title", descriptor.getTitle());
        this.put("type", descriptor.getType());
        this.put("maxValues", descriptor.getMaxValues());
        this.put("operator", descriptor.getOperator());
        if (descriptor.getVocabulary() != null) {
            this.put("vocabulary", descriptor.getVocabulary());
        }
        this.put("hidden", hidden);
    }

    public static FilterSetItem fromJSON(JSONObject obj) {
        FilterSetItem filterSetItem = new FilterSetItem();
        for (String key : obj.keySet()) {
            filterSetItem.put(key, obj.get(key));
        }
        String dateStr = (String)filterSetItem.get("date_min");
        if (dateStr != null) {
            Calendar dateMin = Calendar.getInstance();
            try {
                dateMin.setTime(dateFormat.parse(dateStr));
            }
            catch (ParseException e) {
                log.error((Object)"Failed to parse date_min", (Throwable)e);
            }
            filterSetItem.setDateMinValue(dateMin);
        }
        if ((dateStr = (String)filterSetItem.get("date_max")) != null) {
            Calendar dateMax = Calendar.getInstance();
            try {
                dateMax.setTime(dateFormat.parse(dateStr));
            }
            catch (ParseException e) {
                log.error((Object)"Failed to parse date_max", (Throwable)e);
            }
            filterSetItem.setDateMaxValue(dateMax);
        }
        return filterSetItem;
    }

    public JSONObject toJSON(Locale locale) {
        String i18nTitle;
        JSONObject obj = new JSONObject();
        obj.accumulateAll((Map)this);
        Calendar date = this.getDateMinValue();
        if (date != null) {
            obj.put((Object)"date_min", (Object)dateFormat.format(date.getTime()));
        }
        if ((date = this.getDateMaxValue()) != null) {
            obj.put((Object)"date_max", (Object)dateFormat.format(date.getTime()));
        }
        if ((i18nTitle = I18NUtils.getMessageString((String)"messages", (String)((String)this.get("title")), null, (Locale)locale)) != null) {
            obj.put((Object)"title", (Object)i18nTitle);
        }
        return obj;
    }

    public String getName() {
        return (String)this.get("name");
    }

    public void setName(String name) {
        this.put("name", name);
    }

    public String getIndex() {
        return (String)this.get("index");
    }

    public void setIndex(String index) {
        this.put("index", index);
    }

    public String getTitle() {
        return (String)this.get("title");
    }

    public void setTitle(String title) {
        this.put("title", title);
    }

    public String getType() {
        return (String)this.get("type");
    }

    public void setType(String type) {
        this.put("type", type);
    }

    public Integer getMaxValues() {
        return (Integer)this.get("maxValues");
    }

    public void setMaxValues(Integer maxValues) {
        this.put("maxValues", maxValues);
    }

    public String getOperator() {
        return (String)this.get("operator");
    }

    public void setOperator(String operator) {
        this.put("operator", operator);
    }

    public String getVocabulary() {
        return (String)this.get("vocabulary");
    }

    public void setVocabulary(String vocabulary) {
        this.put("vocabulary", vocabulary);
    }

    public Boolean getHidden() {
        return (Boolean)this.get("hidden");
    }

    public void setHidden(Boolean hidden) {
        this.put("hidden", hidden);
    }

    public String getStringValue() {
        return (String)this.get("string");
    }

    public void setStringValue(String stringValue) {
        this.put("string", stringValue);
    }

    public List<String> getStringValues() {
        return (List)this.get("strings");
    }

    public void setStringValues(List<String> stringValues) {
        this.put("strings", stringValues);
    }

    public Calendar getDateMinValue() {
        return (Calendar)this.get("date_min");
    }

    public void setDateMinValue(Calendar dateMin) {
        this.put("date_min", dateMin);
    }

    public Calendar getDateMaxValue() {
        return (Calendar)this.get("date_max");
    }

    public void setDateMaxValue(Calendar dateMax) {
        this.put("date_max", dateMax);
    }
}

