/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.searchcenter.service;

import java.io.Serializable;
import java.security.Principal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.FieldDescriptor;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.PredicateDescriptor;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.QueryModelDescriptor;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.WhereClauseDescriptor;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.searchcenter.model.FilterSet;
import org.nuxeo.ecm.searchcenter.model.FilterSetItem;
import org.nuxeo.ecm.searchcenter.service.ActionURLDescriptor;
import org.nuxeo.ecm.searchcenter.service.FilterSetDescriptor;
import org.nuxeo.ecm.searchcenter.service.FilterSetItemDescriptor;
import org.nuxeo.ecm.searchcenter.service.FilterWidgetDescriptor;
import org.nuxeo.ecm.searchcenter.service.ResultAttributeDescriptor;
import org.nuxeo.ecm.searchcenter.service.ResultLayoutDescriptor;
import org.nuxeo.ecm.searchcenter.service.SearchCenterService;
import org.nuxeo.ecm.searchcenter.service.URLFactoryDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchCenterServiceImpl
extends DefaultComponent
implements SearchCenterService {
    private static final Log log = LogFactory.getLog(SearchCenterServiceImpl.class);
    protected static final String FILTER_WIDGET_EP = "filterWidget";
    protected static final String FILTER_SET_EP = "filterSet";
    protected static final String URL_FACTORIES_EP = "urlFactories";
    protected static final String ACTION_URL_EP = "actionURL";
    protected static final String RESULT_ATTRIBUTE_EP = "resultAttribute";
    protected static final String RESULT_LAYOUT_EP = "resultLayout";
    protected final Map<String, FilterWidgetDescriptor> filterWidgetRegistry = new HashMap<String, FilterWidgetDescriptor>();
    protected final Map<String, FilterSetDescriptor> filterSetRegistry = new HashMap<String, FilterSetDescriptor>();
    protected final Map<String, String> urlFactories = new HashMap<String, String>();
    protected final Map<String, String> actionURLs = new HashMap<String, String>();
    protected final Map<String, ResultAttributeDescriptor> resultAttributes = new HashMap<String, ResultAttributeDescriptor>();
    protected ResultLayoutDescriptor resultLayout;
    protected static String FILTER_SET_DOCTYPE = "FilterSet";
    protected static String FILTER_SETS_QUERY = "SELECT * FROM Document WHERE ecm:primaryType = 'FilterSet' AND ecm:isCheckedInVersion = 0";

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (FILTER_WIDGET_EP.equals(extensionPoint)) {
            this.registerFilterWidget((FilterWidgetDescriptor)contribution, contributor);
        } else if (FILTER_SET_EP.equals(extensionPoint)) {
            this.registerFilterSet((FilterSetDescriptor)contribution, contributor);
        } else if (URL_FACTORIES_EP.equals(extensionPoint)) {
            this.registerURLFactory((URLFactoryDescriptor)contribution);
        } else if (ACTION_URL_EP.equals(extensionPoint)) {
            this.registerActionURL((ActionURLDescriptor)contribution);
        } else if (RESULT_ATTRIBUTE_EP.equals(extensionPoint)) {
            this.registerResultAttribute((ResultAttributeDescriptor)contribution);
        } else if (RESULT_LAYOUT_EP.equals(extensionPoint)) {
            this.resultLayout = (ResultLayoutDescriptor)contribution;
        } else {
            log.error((Object)String.format("Unknown extension point %s, can't register !", extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (FILTER_WIDGET_EP.equals(extensionPoint)) {
            this.unregisterFilterWidget((FilterWidgetDescriptor)contribution);
        } else if (FILTER_SET_EP.equals(extensionPoint)) {
            this.unregisterFilterSet((FilterSetDescriptor)contribution);
        } else if (URL_FACTORIES_EP.equals(extensionPoint)) {
            this.unregisterURLFactory((URLFactoryDescriptor)contribution);
        } else if (ACTION_URL_EP.equals(extensionPoint)) {
            this.unregisterActionURL((ActionURLDescriptor)contribution);
        } else if (RESULT_ATTRIBUTE_EP.equals(extensionPoint)) {
            this.unregisterResultAttribute((ResultAttributeDescriptor)contribution);
        } else if (!RESULT_LAYOUT_EP.equals(extensionPoint)) {
            log.error((Object)String.format("Unknown extension point %s, can't unregister !", extensionPoint));
        }
    }

    protected void registerFilterWidget(FilterWidgetDescriptor filterWidget, ComponentInstance component) {
        String name = filterWidget.getName();
        this.filterWidgetRegistry.put(name, filterWidget);
        log.debug((Object)String.format("Registered filterWidget: %s", name));
    }

    protected void unregisterFilterWidget(FilterWidgetDescriptor filterWidget) {
        String name = filterWidget.getName();
        this.filterWidgetRegistry.remove(name);
        log.debug((Object)("Unregistered filterWidget: " + name));
    }

    protected void registerFilterSet(FilterSetDescriptor filterSet, ComponentInstance component) {
        String name = filterSet.getName();
        this.filterSetRegistry.put(name, filterSet);
        log.debug((Object)String.format("Registered filterSet: %s", name));
    }

    protected void unregisterFilterSet(FilterSetDescriptor filterSet) {
        String name = filterSet.getName();
        this.filterSetRegistry.remove(name);
        log.debug((Object)("Unregistered filterSet: " + name));
    }

    protected void registerURLFactory(URLFactoryDescriptor factoryDescriptor) {
        this.urlFactories.put(factoryDescriptor.getName(), factoryDescriptor.getPattern());
    }

    protected void unregisterURLFactory(URLFactoryDescriptor factoryDescriptor) {
        this.urlFactories.remove(factoryDescriptor.getName());
    }

    protected void registerActionURL(ActionURLDescriptor actionURLDescriptor) {
        this.actionURLs.put(actionURLDescriptor.getAction(), actionURLDescriptor.getFactory());
    }

    protected void unregisterActionURL(ActionURLDescriptor actionURLDescriptor) {
        this.actionURLs.remove(actionURLDescriptor.getAction());
    }

    protected void registerResultAttribute(ResultAttributeDescriptor resultAttributeDescriptor) {
        this.resultAttributes.put(resultAttributeDescriptor.getName(), resultAttributeDescriptor);
    }

    protected void unregisterResultAttribute(ResultAttributeDescriptor resultAttributeDescriptor) {
        this.resultAttributes.remove(resultAttributeDescriptor.getName());
    }

    @Override
    public FilterSet getContributedFilterSet(String name) {
        FilterSetDescriptor filterSetDesc = this.filterSetRegistry.get(name);
        if (filterSetDesc == null || !filterSetDesc.isEnabled().booleanValue()) {
            return null;
        }
        ArrayList<FilterSetItem> filterSetItems = new ArrayList<FilterSetItem>();
        for (FilterSetItemDescriptor filterSetItemDesc : filterSetDesc.getFilterSetItems()) {
            FilterWidgetDescriptor filterWidgetDesc = this.filterWidgetRegistry.get(filterSetItemDesc.getWidgetName());
            if (filterWidgetDesc == null) continue;
            FilterSetItem filterSetItem = new FilterSetItem(filterWidgetDesc, filterSetItemDesc.getHidden());
            filterSetItems.add(filterSetItem);
        }
        FilterSet filterSet = new FilterSet(filterSetDesc.getTitle(), filterSetDesc.getName(), null, filterSetItems);
        return filterSet;
    }

    @Override
    public FilterSet getDefaultFilterSet() {
        FilterSet filterSet = this.getContributedFilterSet("default");
        if (filterSet == null) {
            // empty if block
        }
        return filterSet;
    }

    @Override
    public String getUrlFor(String baseUrl, String action, DocumentModel doc) {
        String urlPattern = this.urlFactories.get(this.actionURLs.get(action));
        urlPattern = urlPattern.replace("{repo}", doc.getRepositoryName());
        urlPattern = urlPattern.replace("{path}", doc.getPathAsString());
        urlPattern = urlPattern.replace("{docid}", doc.getId());
        return baseUrl + urlPattern;
    }

    protected DocumentModel getFilterSetDocument(CoreSession session, FilterSet filterSet) throws ClientException {
        DocumentModel dm = session.createDocumentModel(FILTER_SET_DOCTYPE);
        dm.setPropertyValue("fs:filterWidgets", (Serializable)((Object)filterSet.getItems()));
        dm.setPropertyValue("fs:name", (Serializable)((Object)filterSet.getName()));
        return dm;
    }

    protected QueryModelDescriptor getQueryModelDescriptor(FilterSet filterSet) {
        List<FilterSetItem> filterSetItems = filterSet.getItems();
        ArrayList<PredicateDescriptor> predicates = new ArrayList<PredicateDescriptor>();
        for (int i = 0; i < filterSetItems.size(); ++i) {
            FieldDescriptor[] fields;
            FilterSetItem filterSetItem = filterSetItems.get(i);
            PredicateDescriptor predicate = new PredicateDescriptor();
            predicate.setParameter(filterSetItem.getIndex());
            predicate.setOperator(filterSetItem.getOperator());
            String widgetType = filterSetItem.getType();
            if ("string".equals(widgetType) || "vocabulary".equals(widgetType) || "hierarchicalVocabulary".equals(widgetType)) {
                if (filterSetItem.getMaxValues() == 1) {
                    fields = new FieldDescriptor[]{new FieldDescriptor("fs:filterWidgets/" + i + "/" + "string")};
                    predicate.setValues(fields);
                } else {
                    fields = new FieldDescriptor[]{new FieldDescriptor("fs:filterWidgets/" + i + "/" + "strings")};
                    predicate.setValues(fields);
                }
            } else if ("date".equals(widgetType)) {
                fields = new FieldDescriptor[]{new FieldDescriptor("fs:filterWidgets/" + i + "/" + "date_min"), new FieldDescriptor("fs:filterWidgets/" + i + "/" + "date_max")};
                predicate.setValues(fields);
            }
            predicates.add(predicate);
        }
        WhereClauseDescriptor whereClause = new WhereClauseDescriptor();
        whereClause.setPredicates(predicates.toArray(new PredicateDescriptor[predicates.size()]));
        whereClause.setFixedPart(this.filterSetRegistry.get("default").getFixedPart());
        FieldDescriptor sortColumnField = new FieldDescriptor("fs:sortColumn");
        FieldDescriptor sortAscendingField = new FieldDescriptor("fs:sortAscending");
        QueryModelDescriptor descriptor = new QueryModelDescriptor("FILTER_SEARCH", FILTER_SET_DOCTYPE, Integer.valueOf(10), whereClause, sortColumnField, sortAscendingField);
        return descriptor;
    }

    @Override
    public DocumentModelList execQuery(CoreSession session, FilterSet filterSet) throws ClientException {
        QueryModelDescriptor descriptor = this.getQueryModelDescriptor(filterSet);
        DocumentModel dm = this.getFilterSetDocument(session, filterSet);
        QueryModel model = new QueryModel(descriptor, dm);
        PagedDocumentsProvider resultProvider = model.getResultsProvider(session, null);
        return resultProvider.getCurrentPage();
    }

    @Override
    public String saveFilterSet(CoreSession session, Principal principal, FilterSet filterSet, String title) throws ClientException {
        UserWorkspaceService userWorkspaceService;
        DocumentModel dm = this.getFilterSetDocument(session, filterSet);
        try {
            userWorkspaceService = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
        }
        catch (Exception e) {
            throw new ClientException("Failed to get UserWorkspaceService", (Throwable)e);
        }
        DocumentModel userWorkspace = userWorkspaceService.getCurrentUserPersonalWorkspace(principal.getName(), session.getDocument((DocumentRef)new PathRef("/default-domain")));
        dm.setPathInfo(userWorkspace.getPathAsString(), IdUtils.generateId((String)title));
        dm.setPropertyValue("dc:title", (Serializable)((Object)title));
        dm = session.createDocument(dm);
        session.save();
        return dm.getId();
    }

    @Override
    public FilterSet getSavedFilterSet(CoreSession session, String docId) throws ClientException {
        List filterSetItemsMap;
        String filterSetName;
        String title;
        IdRef docRef = new IdRef(docId);
        if (!session.exists((DocumentRef)docRef)) {
            return null;
        }
        DocumentModel dm = session.getDocument((DocumentRef)docRef);
        try {
            title = (String)((Object)dm.getPropertyValue("dc:title"));
            filterSetName = (String)((Object)dm.getPropertyValue("fs:name"));
            filterSetItemsMap = (List)((Object)dm.getPropertyValue("fs:filterWidgets"));
        }
        catch (PropertyException e) {
            throw new ClientException("Failed to get FilterSet", (ClientException)e);
        }
        ArrayList<FilterSetItem> filterSetItems = new ArrayList<FilterSetItem>();
        for (Map m : filterSetItemsMap) {
            filterSetItems.add(new FilterSetItem(m));
        }
        return new FilterSet(title, filterSetName, docId, filterSetItems);
    }

    @Override
    public FilterSet getFilterSet(CoreSession session, String id) throws ClientException {
        FilterSet filterSet = this.getSavedFilterSet(session, id);
        if (filterSet == null) {
            filterSet = this.getContributedFilterSet(id);
        }
        return filterSet;
    }

    @Override
    public List<FilterSet> getFilterSets(CoreSession session, Principal principal) throws ClientException {
        ArrayList<FilterSet> filterSets = new ArrayList<FilterSet>();
        for (FilterSetDescriptor filterSetDesc : this.filterSetRegistry.values()) {
            if (!filterSetDesc.isEnabled().booleanValue()) continue;
            filterSets.add(new FilterSet(filterSetDesc.getTitle(), filterSetDesc.getName(), null, null));
        }
        for (DocumentModel dm : session.query(FILTER_SETS_QUERY)) {
            String title;
            try {
                title = (String)((Object)dm.getPropertyValue("dc:title"));
            }
            catch (PropertyException e) {
                throw new ClientException("Failed to get FilterSets", (ClientException)e);
            }
            filterSets.add(new FilterSet(title, null, dm.getId(), null));
        }
        return filterSets;
    }

    protected String replaceAttributes(DocumentModel doc, String str) throws PropertyException, ClientException {
        for (String attrName : this.resultAttributes.keySet()) {
            ResultAttributeDescriptor resultAttribute = this.resultAttributes.get(attrName);
            String attrValue = "";
            if ("string".equals(resultAttribute.getType())) {
                attrValue = (String)((Object)doc.getPropertyValue(resultAttribute.getXpath()));
            } else if ("long".equals(resultAttribute.getType())) {
                attrValue = ((Long)doc.getPropertyValue(resultAttribute.getXpath())).toString();
            } else if ("date".equals(resultAttribute.getType())) {
                Calendar cal = (Calendar)doc.getPropertyValue(resultAttribute.getXpath());
                attrValue = DateFormat.getDateInstance().format(cal.getTime());
            }
            if (attrValue == null) {
                attrValue = "";
            }
            str = str.replace("{" + attrName + "}", attrValue);
        }
        return str;
    }

    @Override
    public String getResultHead(DocumentModel doc) throws PropertyException, ClientException {
        String head = this.resultLayout.getHead();
        head = this.replaceAttributes(doc, head);
        return head;
    }

    @Override
    public String getResultBody(DocumentModel doc) throws PropertyException, ClientException {
        String body = this.resultLayout.getBody();
        body = this.replaceAttributes(doc, body);
        return body;
    }
}

