/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.mini.message;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.ActivitiesListImpl;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityStreamFilter;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.activity.ActivityStreamServiceImpl;
import org.nuxeo.ecm.social.relationship.RelationshipKind;
import org.nuxeo.ecm.social.relationship.service.RelationshipService;
import org.nuxeo.runtime.api.Framework;

public class MiniMessageActivityStreamFilter
implements ActivityStreamFilter {
    public static final String ID = "MiniMessageActivityStreamFilter";
    public static final String VERB = "minimessage";
    public static final String QUERY_TYPE_PARAMETER = "queryType";
    public static final String ACTOR_PARAMETER = "actor";
    public static final String RELATIONSHIP_KIND_PARAMETER = "relationshipKind";
    public static final String TARGET_PARAMETER = "target";

    public String getId() {
        return ID;
    }

    public boolean isInterestedIn(Activity activity) {
        return true;
    }

    public void handleNewActivity(ActivityStreamService activityStreamService, Activity activity) {
    }

    public void handleRemovedActivities(ActivityStreamService activityStreamService, Collection<Serializable> activityIds) {
    }

    public ActivitiesList query(ActivityStreamService activityStreamService, Map<String, Serializable> parameters, long offset, long limit) {
        Query query;
        QueryType queryType = (QueryType)((Object)parameters.get(QUERY_TYPE_PARAMETER));
        if (queryType == null) {
            throw new IllegalArgumentException("queryType is required.");
        }
        String actor = (String)((Object)parameters.get(ACTOR_PARAMETER));
        if (actor == null) {
            throw new IllegalArgumentException("actor is required");
        }
        String target = (String)((Object)parameters.get(TARGET_PARAMETER));
        EntityManager em = ((ActivityStreamServiceImpl)activityStreamService).getEntityManager();
        switch (queryType) {
            case MINI_MESSAGES_FOR_ACTOR: {
                RelationshipKind relationshipKind = (RelationshipKind)parameters.get(RELATIONSHIP_KIND_PARAMETER);
                RelationshipService relationshipService = (RelationshipService)Framework.getLocalService(RelationshipService.class);
                List actors = relationshipService.getTargetsOfKind(actor, relationshipKind);
                actors.add(actor);
                StringBuilder sb = new StringBuilder("select activity from Activity activity where activity.actor in (:actors) and activity.verb = :verb ");
                if (target != null) {
                    sb.append("and activity.target = :target ");
                } else {
                    sb.append("and activity.target is null ");
                }
                sb.append("order by activity.publishedDate desc");
                query = em.createQuery(sb.toString());
                query.setParameter("actors", (Object)actors);
                query.setParameter("verb", (Object)VERB);
                if (target == null) break;
                query.setParameter(TARGET_PARAMETER, (Object)target);
                break;
            }
            case MINI_MESSAGES_FROM_ACTOR: {
                query = em.createQuery("select activity from Activity activity where activity.actor = :actor and activity.verb = :verb order by activity.publishedDate desc");
                query.setParameter(ACTOR_PARAMETER, (Object)actor);
                query.setParameter("verb", (Object)VERB);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid QueryType parameter");
            }
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
            if (offset > 0L) {
                query.setFirstResult((int)offset);
            }
        }
        return new ActivitiesListImpl((Collection)query.getResultList());
    }

    public static enum QueryType {
        MINI_MESSAGES_FOR_ACTOR,
        MINI_MESSAGES_FROM_ACTOR;

    }
}

