/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.mini.message;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.activity.AbstractActivityPageProvider;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.social.mini.message.MiniMessage;

public class MiniMessageHelper {
    public static Pattern HTTP_URL_PATTERN = Pattern.compile("\\b(https?://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])");

    private MiniMessageHelper() {
    }

    public static String replaceURLsByLinks(String message) {
        String escapedMessage = StringEscapeUtils.escapeHtml((String)message);
        Matcher m = HTTP_URL_PATTERN.matcher(escapedMessage);
        StringBuffer sb = new StringBuffer(escapedMessage.length());
        while (m.find()) {
            String url = m.group(1);
            m.appendReplacement(sb, MiniMessageHelper.computeLinkFor(url));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String computeLinkFor(String url) {
        return "<a href=\"" + url + "\" target=\"_top\">" + url + "</a>";
    }

    public static String toJSON(PageProvider<MiniMessage> pageProvider, Locale locale, CoreSession session) {
        try {
            DateFormat dateFormat = DateFormat.getDateInstance(2, locale);
            ArrayList miniMessages = new ArrayList();
            for (MiniMessage miniMessage : pageProvider.getCurrentPage()) {
                HashMap<String, Object> o = new HashMap<String, Object>();
                o.put("id", miniMessage.getId());
                o.put("actor", miniMessage.getActor());
                o.put("displayActor", miniMessage.getDisplayActor());
                o.put("message", miniMessage.getMessage());
                o.put("publishedDate", dateFormat.format(miniMessage.getPublishedDate()));
                o.put("isCurrentUserMiniMessage", session.getPrincipal().getName().equals(miniMessage.getActor()));
                miniMessages.add(o);
            }
            HashMap<String, Serializable> m = new HashMap<String, Serializable>();
            m.put("offset", Long.valueOf(((AbstractActivityPageProvider)pageProvider).getNextOffset()));
            m.put("limit", Long.valueOf(pageProvider.getCurrentPageSize()));
            m.put("miniMessages", miniMessages);
            ObjectMapper mapper = new ObjectMapper();
            StringWriter writer = new StringWriter();
            mapper.writeValue((Writer)writer, m);
            return writer.toString();
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

