/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.gadgets.webengine;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.util.PaginableDocumentModelList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.TypeService;
import org.nuxeo.ecm.platform.comment.api.CommentableDocument;
import org.nuxeo.ecm.platform.comment.workflow.utils.FollowTransitionUnrestricted;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.types.TypeView;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.rating.api.LikeService;
import org.nuxeo.ecm.social.workspace.adapters.SocialDocument;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.Template;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="/social")
@WebObject(type="social")
@Produces(value={"text/html; charset=UTF-8"})
public class SocialWebEngineRoot
extends ModuleRoot {
    private static final Log log = LogFactory.getLog(SocialWebEngineRoot.class);
    static AutomationService automationService;
    protected static final String AVATAR_PROPERTY = "userprofile:avatar";

    @GET
    public Object index(@Context HttpServletRequest request) throws Exception {
        FormData formData = new FormData(request);
        String lang = formData.getString("lang");
        this.setLanguage(lang);
        this.setDocumentLinkBuilder(formData.getString("documentLinkBuilder"));
        String ref = formData.getString("docRef");
        String queryText = formData.getString("queryText");
        int pageSize = SocialWebEngineRoot.getIntFromString(formData.getString("limit"));
        int page = SocialWebEngineRoot.getIntFromString(formData.getString("page"));
        return this.buildDocumentList(ref, pageSize, page, queryText).arg("renderFullHtml", (Object)true);
    }

    @POST
    @Path(value="documentList")
    public Object documentList(@Context HttpServletRequest request) throws Exception {
        FormData formData = new FormData(request);
        String lang = formData.getString("lang");
        this.setLanguage(lang);
        this.setDocumentLinkBuilder(formData.getString("documentLinkBuilder"));
        String ref = formData.getString("docRef");
        int pageSize = SocialWebEngineRoot.getIntFromString(formData.getString("limit"));
        int page = SocialWebEngineRoot.getIntFromString(formData.getString("page"));
        return this.buildDocumentList(ref, pageSize, page, null);
    }

    @GET
    @Path(value="documentListGet")
    public Object documentListGet(@Context HttpServletRequest request) throws Exception {
        FormData formData = new FormData(request);
        String lang = formData.getString("lang");
        this.setLanguage(lang);
        this.setDocumentLinkBuilder(formData.getString("documentLinkBuilder"));
        String ref = formData.getString("docRef");
        int pageSize = SocialWebEngineRoot.getIntFromString(formData.getString("limit"));
        int page = SocialWebEngineRoot.getIntFromString(formData.getString("page"));
        return this.buildDocumentList(ref, pageSize, page, null);
    }

    @POST
    @Path(value="search")
    public Object search(@Context HttpServletRequest request) throws Exception {
        FormData formData = new FormData(request);
        String lang = formData.getString("lang");
        this.setLanguage(lang);
        this.setDocumentLinkBuilder(formData.getString("documentLinkBuilder"));
        String ref = formData.getString("docRef");
        int pageSize = SocialWebEngineRoot.getIntFromString(formData.getString("limit"));
        int page = SocialWebEngineRoot.getIntFromString(formData.getString("page"));
        String queryText = formData.getString("queryText");
        return this.buildDocumentList(ref, pageSize, page, queryText);
    }

    Template buildDocumentList(String ref, int pageSize, int page, String queryText) throws Exception {
        DocumentRef docRef = SocialWebEngineRoot.getDocumentRef(ref);
        return this.buildDocumentList(docRef, pageSize, page, queryText);
    }

    Template buildDocumentList(DocumentRef docRef, int pageSize, int page, String queryText) throws Exception {
        PaginableDocumentModelList docs;
        boolean isSearch = queryText != null && queryText.trim().length() > 0;
        HashMap<String, Object> args = new HashMap<String, Object>();
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel doc = session.getDocument(docRef);
        args.put("currentDoc", doc);
        DocumentModel socialWorkspace = null;
        if (isSearch) {
            docs = SocialWebEngineRoot.search(doc, pageSize, page, queryText);
            socialWorkspace = doc;
            args.put("queryText", queryText);
        } else {
            docs = SocialWebEngineRoot.getChildren(doc, pageSize, page);
            List<DocumentModel> ancestors = SocialWebEngineRoot.getAncestors(doc);
            DocumentModel parent = null;
            if (ancestors.size() > 1) {
                parent = ancestors.get(ancestors.size() - 2);
            }
            args.put("parent", parent);
            if (!ancestors.isEmpty() && SocialWebEngineRoot.isSocialWorkspace(ancestors.get(0))) {
                socialWorkspace = ancestors.remove(0);
            }
            args.put("ancestors", ancestors);
            args.put("queryText", "");
        }
        args.put("socialWorkspace", socialWorkspace);
        args.put("docs", docs);
        args.put("publishablePublic", SocialWebEngineRoot.getPublishableDocs(socialWorkspace, (DocumentModelList)docs, true));
        args.put("publishablePrivate", SocialWebEngineRoot.getPublishableDocs(socialWorkspace, (DocumentModelList)docs, false));
        args.put("removable", SocialWebEngineRoot.getDocsWithDeleteRight((DocumentModelList)docs));
        args.put("isPublicSocialWorkspace", socialWorkspace.getPropertyValue("socialw:isPublic"));
        args.put("collaboration_views", SocialWebEngineRoot.getCollaborationViews((DocumentModelList)docs));
        args.put("page", docs.getCurrentPageIndex());
        args.put("maxPage", docs.getNumberOfPages());
        if (docs.getNumberOfPages() > 0L) {
            args.put("nextPage", (long)page < docs.getNumberOfPages() - 1L ? page + 1 : page);
        } else {
            args.put("nextPage", page + 1);
        }
        args.put("prevPage", page > 0 ? page - 1 : page);
        if (isSearch) {
            return this.getView("search_result").args(args);
        }
        return this.getView("children_list").args(args);
    }

    @POST
    @Path(value="publishDocument")
    public Object publishDocument(@Context HttpServletRequest request) throws Exception {
        DocumentRef docRef;
        FormData formData = new FormData(request);
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel target = session.getDocument(docRef = SocialWebEngineRoot.getDocumentRef(formData.getString("targetRef")));
        SocialDocument socialDocument = SocialWorkspaceHelper.toSocialDocument((DocumentModel)target);
        if (socialDocument == null) {
            throw new ClientException("Can't fetch social document.");
        }
        boolean isPublic = "true".equals(formData.getString("public"));
        if (isPublic) {
            socialDocument.makePublic();
        } else {
            socialDocument.restrictToMembers();
        }
        return this.documentList(request);
    }

    @POST
    @Path(value="deleteDocument")
    public Object deleteDocument(@Context HttpServletRequest request) throws Exception {
        FormData formData = new FormData(request);
        String target = formData.getString("targetRef");
        DocumentRef docRef = SocialWebEngineRoot.getDocumentRef(target);
        CoreSession session = this.ctx.getCoreSession();
        if (session.getAllowedStateTransitions(docRef).contains("delete")) {
            session.followTransition(docRef, "delete");
        } else {
            session.removeDocument(docRef);
        }
        return this.documentList(request);
    }

    @GET
    @Path(value="createDocumentForm")
    public Object createDocumentForm(@QueryParam(value="docRef") String ref, @QueryParam(value="doctype") String docTypeId, @QueryParam(value="lang") String lang) throws Exception {
        this.setLanguage(lang);
        DocumentRef docRef = SocialWebEngineRoot.getDocumentRef(ref);
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel currentDoc = session.getDocument(docRef);
        DocumentType coreType = TypeService.getSchemaManager().getDocumentType(docTypeId);
        return this.getView("create_document_form").arg("currentDoc", (Object)currentDoc).arg("docType", (Object)SocialWebEngineRoot.getTypeService().getType(docTypeId)).arg("coreType", (Object)coreType);
    }

    @GET
    @Path(value="selectDocTypeToCreate")
    public Object selectDocTypeToCreate(@QueryParam(value="docRef") String ref, @QueryParam(value="lang") String lang) throws ClientException {
        this.setLanguage(lang);
        DocumentRef docRef = SocialWebEngineRoot.getDocumentRef(ref);
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel currentDoc = session.getDocument(docRef);
        TypeManager typeService = SocialWebEngineRoot.getTypeService();
        Map types = typeService.getTypeMapForDocumentType(currentDoc.getType(), currentDoc);
        this.filterAllowedTypes(types);
        return this.getView("select_doc_type").arg("currentDoc", (Object)currentDoc).arg("docTypes", (Object)types).arg("categories", types.keySet()).arg("lang", (Object)lang);
    }

    protected void filterAllowedTypes(Map<String, List<Type>> typesMap) {
        for (String key : typesMap.keySet()) {
            ArrayList<Type> toRemoved = new ArrayList<Type>();
            List<Type> types = typesMap.get(key);
            for (Type type : types) {
                if (this.isAllowedLibraryType(type)) continue;
                toRemoved.add(type);
            }
            types.removeAll(toRemoved);
        }
    }

    protected boolean isAllowedLibraryType(Type type) {
        return !type.getId().equals("VEVENT");
    }

    protected static TypeManager getTypeService() throws ClientException {
        TypeManager typeService;
        try {
            typeService = (TypeManager)Framework.getService(TypeManager.class);
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), (Throwable)e);
        }
        if (typeService == null) {
            throw new ClientException("Can't fetch the typeService, please contact your administrator");
        }
        return typeService;
    }

    @POST
    @Path(value="createDocument")
    public Object createDocument(@Context HttpServletRequest request) throws Exception {
        CoreSession session = this.ctx.getCoreSession();
        FormData formData = new FormData(request);
        String type = formData.getDocumentType();
        String title = formData.getDocumentTitle();
        DocumentRef docRef = SocialWebEngineRoot.getDocumentRef(formData.getString("docRef"));
        DocumentModel parent = session.getDocument(docRef);
        DocumentModel newDoc = session.createDocumentModel(parent.getPathAsString(), title, type);
        formData.fillDocument(newDoc);
        newDoc = session.createDocument(newDoc);
        session.save();
        if (newDoc.isFolder()) {
            return this.buildDocumentList(newDoc.getId(), 0, 0, null);
        }
        return this.buildDocumentList(parent.getId(), 0, 0, null);
    }

    protected static PaginableDocumentModelList getChildren(DocumentModel doc, int pageSize, int page) throws Exception {
        CoreSession session = doc.getCoreSession();
        OperationContext ctx = new OperationContext(session);
        OperationChain chain = new OperationChain("getChildren");
        String query = "SELECT * FROM Document WHERE ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'AND ecm:parentId = '" + doc.getId() + "' " + "ORDER BY dc:title";
        chain.add("Document.PageProvider").set("query", (Object)query).set("page", (Object)page).set("pageSize", (Object)(pageSize > 0 ? pageSize : 5));
        return (PaginableDocumentModelList)SocialWebEngineRoot.getAutomationService().run(ctx, chain);
    }

    protected static PaginableDocumentModelList search(DocumentModel doc, int pageSize, int page, String queryText) throws Exception {
        CoreSession session = doc.getCoreSession();
        OperationContext ctx = new OperationContext(session);
        OperationChain chain = new OperationChain("search");
        String escapedQueryText = NXQLQueryBuilder.prepareStringLiteral((String)queryText.trim(), (boolean)false, (boolean)true);
        String query = "SELECT * FROM Document WHERE ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0 AND ecm:currentLifeCycleState != 'deleted' AND ecm:fulltext = '" + escapedQueryText + "%' " + "AND ecm:path STARTSWITH '" + doc.getPathAsString() + "' " + "ORDER BY dc:title";
        chain.add("Document.PageProvider").set("query", (Object)query).set("page", (Object)page).set("pageSize", (Object)(pageSize > 0 ? pageSize : 5));
        return (PaginableDocumentModelList)SocialWebEngineRoot.getAutomationService().run(ctx, chain);
    }

    protected static List<DocumentModel> getAncestors(DocumentModel doc) throws ClientException {
        ArrayList<DocumentModel> list = new ArrayList<DocumentModel>();
        CoreSession session = doc.getCoreSession();
        list.add(doc);
        while (doc != null && !SocialWebEngineRoot.isSocialWorkspace(doc)) {
            doc = session.getParentDocument(doc.getRef());
            list.add(0, doc);
        }
        return list;
    }

    protected static boolean isSocialWorkspace(DocumentModel doc) {
        return doc != null && doc.hasFacet("SocialWorkspace");
    }

    protected static DocumentRef getDocumentRef(String ref) {
        Object docRef = ref != null && ref.startsWith("/") ? new PathRef(ref) : new IdRef(ref);
        return docRef;
    }

    protected void setLanguage(String lang) {
        if (lang != null && lang.trim().length() > 0) {
            Locale locale = new Locale(lang);
            this.ctx.setLocale(locale);
        }
    }

    protected void setDocumentLinkBuilder(String documentLinkBuilder) {
        if (!StringUtils.isBlank((String)documentLinkBuilder)) {
            this.ctx.setProperty("documentLinkBuilder", (Object)documentLinkBuilder);
        }
    }

    protected static int getIntFromString(String value) {
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static AutomationService getAutomationService() throws Exception {
        if (automationService == null) {
            automationService = (AutomationService)Framework.getService(AutomationService.class);
        }
        return automationService;
    }

    protected static List<String> getPublishableDocs(DocumentModel socialWorkspace, DocumentModelList docs, boolean isPublic) throws ClientException {
        ArrayList<String> list;
        block4: {
            boolean isPublicSocialWorkspace = (Boolean)socialWorkspace.getPropertyValue("socialw:isPublic");
            list = new ArrayList<String>();
            if (!isPublicSocialWorkspace) break block4;
            if (isPublic) {
                for (DocumentModel doc : docs) {
                    SocialDocument socialDocument = SocialWorkspaceHelper.toSocialDocument((DocumentModel)doc);
                    if (socialDocument == null || !socialDocument.isRestrictedToMembers()) continue;
                    list.add(doc.getId());
                }
            } else {
                for (DocumentModel doc : docs) {
                    SocialDocument socialDocument = SocialWorkspaceHelper.toSocialDocument((DocumentModel)doc);
                    if (socialDocument == null || !socialDocument.isPublic()) continue;
                    list.add(doc.getId());
                }
            }
        }
        return list;
    }

    protected static List<String> getDocsWithDeleteRight(DocumentModelList docs) throws ClientException {
        ArrayList<String> docsIdResult = new ArrayList<String>();
        if (docs.isEmpty()) {
            return docsIdResult;
        }
        CoreSession session = ((DocumentModel)docs.get(0)).getCoreSession();
        for (DocumentModel doc : docs) {
            if (!session.hasPermission(doc.getRef(), "Remove") || !session.hasPermission(session.getParentDocumentRef(doc.getRef()), "RemoveChildren")) continue;
            docsIdResult.add(doc.getId());
        }
        return docsIdResult;
    }

    protected static Map<String, String> getCollaborationViews(DocumentModelList docs) throws ClientException {
        TypeManager typeManager;
        HashMap<String, String> viewResults = new HashMap<String, String>();
        if (docs.isEmpty()) {
            return viewResults;
        }
        try {
            typeManager = (TypeManager)Framework.getService(TypeManager.class);
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), (Throwable)e);
        }
        for (DocumentModel doc : docs) {
            Type type = typeManager.getType(doc.getType());
            TypeView view = type.getView("collaboration");
            if (view != null) {
                viewResults.put(doc.getId(), view.getValue());
                continue;
            }
            viewResults.put(doc.getId(), type.getDefaultView());
        }
        return viewResults;
    }

    public String getTranslatedLabel(String label) {
        String newLabel = I18NUtils.getMessageString((String)"messages", (String)label, null, (Locale)this.ctx.getLocale());
        if (newLabel == null) {
            return label;
        }
        return newLabel;
    }

    public Blob getAttachment(DocumentModel doc) throws ClientException {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        return bh != null ? bh.getBlob() : null;
    }

    public String escape(String text) {
        text = StringEscapeUtils.escapeJavaScript((String)text);
        text = StringEscapeUtils.escapeHtml((String)text);
        text = StringEscapeUtils.escapeXml((String)text);
        return text;
    }

    public String escapePath(String text) {
        text = text.replaceAll("'", Matcher.quoteReplacement("\\'"));
        try {
            text = URIUtil.encodePath((String)text);
        }
        catch (Exception e) {
            log.debug((Object)("failed to encode:" + text), (Throwable)e);
        }
        return text;
    }

    public boolean hasAddChildrenRight(String docId) {
        try {
            IdRef docRef = new IdRef(docId);
            boolean hasPermission = this.ctx.getCoreSession().hasPermission((DocumentRef)docRef, "AddChildren");
            return hasPermission;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<DocumentModel> getComments(DocumentModel doc) throws ClientException {
        List comments = null;
        CommentableDocument commentableDoc = (CommentableDocument)doc.getAdapter(CommentableDocument.class);
        if (commentableDoc != null) {
            comments = commentableDoc.getComments();
        }
        return comments;
    }

    @GET
    @Path(value="documentCommentList")
    public Object documentCommentList(@QueryParam(value="docRef") String ref) throws Exception {
        HashMap<String, DocumentModel> args = new HashMap<String, DocumentModel>();
        CoreSession session = this.ctx.getCoreSession();
        IdRef docRef = new IdRef(ref);
        DocumentModel doc = session.getDocument((DocumentRef)docRef);
        args.put("doc", doc);
        return Response.ok((Object)this.getView("document_comments_template").args(args)).header("docRef", (Object)ref).build();
    }

    public List<DocumentModel> getCommentChildren(DocumentModel doc, DocumentModel parent) throws ClientException {
        List comments = null;
        CommentableDocument commentableDoc = (CommentableDocument)doc.getAdapter(CommentableDocument.class);
        if (commentableDoc != null) {
            comments = commentableDoc.getComments(parent);
        }
        return comments;
    }

    @POST
    @Path(value="addComment")
    public Object addComment() throws ClientException {
        try {
            DocumentModel newComment;
            HttpServletRequest request = this.ctx.getRequest();
            CoreSession session = this.ctx.getCoreSession();
            DocumentModel myComment = session.createDocumentModel("Comment");
            myComment.setProperty("comment", "author", (Object)this.ctx.getPrincipal().getName());
            myComment.setProperty("comment", "text", (Object)request.getParameter("commentContent"));
            myComment.setProperty("comment", "creationDate", (Object)Calendar.getInstance());
            String docToCommentRef = request.getParameter("docToCommentRef");
            DocumentModel docToComment = session.getDocument((DocumentRef)new IdRef(docToCommentRef));
            String commentParentRef = request.getParameter("commentParentRef");
            CommentableDocument commentableDoc = null;
            if (docToComment != null) {
                commentableDoc = (CommentableDocument)docToComment.getAdapter(CommentableDocument.class);
            }
            if (commentParentRef != null) {
                DocumentModel commentParent = session.getDocument((DocumentRef)new IdRef(commentParentRef));
                newComment = commentableDoc.addComment(commentParent, myComment);
            } else {
                newComment = commentableDoc.addComment(myComment);
            }
            if ("comment_moderation".equals(newComment.getLifeCyclePolicy())) {
                new FollowTransitionUnrestricted(this.ctx.getCoreSession(), newComment.getRef(), "moderation_publish").runUnrestricted();
            }
            HashMap<String, DocumentModel> args = new HashMap<String, DocumentModel>();
            args.put("doc", docToComment);
            args.put("comment", newComment);
            return Response.ok((Object)this.getView("bricks/document_comments").args(args)).header("docRef", (Object)docToCommentRef).header("parentCommentRef", (Object)commentParentRef).build();
        }
        catch (Throwable t) {
            log.error((Object)"failed to add comment", t);
            throw ClientException.wrap((Throwable)t);
        }
    }

    @POST
    @Path(value="docLike")
    public Object docLike(@FormParam(value="docRef") String docRef) throws Exception {
        String userName;
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel docToLike = session.getDocument((DocumentRef)new IdRef(docRef));
        LikeService likeService = (LikeService)Framework.getLocalService(LikeService.class);
        if (likeService.hasUserLiked(userName = this.ctx.getPrincipal().getName(), docToLike)) {
            likeService.dislike(userName, docToLike);
        } else {
            likeService.like(userName, docToLike);
        }
        return Response.ok((Object)this.getView("bricks/document_like").arg("doc", (Object)docToLike)).header("docRef", (Object)docRef).build();
    }

    public boolean hasUserLiked(DocumentModel doc) {
        LikeService likeService = (LikeService)Framework.getLocalService(LikeService.class);
        String userName = this.ctx.getPrincipal().getName();
        return likeService.hasUserLiked(userName, doc);
    }

    public long getLikesCount(DocumentModel doc) {
        LikeService likeService = (LikeService)Framework.getLocalService(LikeService.class);
        return likeService.getLikesCount(doc);
    }

    public String getAvatarURL(String commentUser) throws ClientException {
        String url = VirtualHostHelper.getContextPathProperty() + "/icons/missing_avatar.png";
        UserProfileService userProfileService = (UserProfileService)Framework.getLocalService(UserProfileService.class);
        DocumentModel userProfileDoc = userProfileService.getUserProfileDocument(commentUser, this.ctx.getCoreSession());
        if (userProfileDoc == null) {
            return url;
        }
        if (userProfileDoc.getPropertyValue(AVATAR_PROPERTY) != null) {
            url = VirtualHostHelper.getContextPathProperty() + "/" + DocumentModelFunctions.fileUrl((String)"downloadFile", (DocumentModel)userProfileDoc, (String)AVATAR_PROPERTY, (String)"avatar");
        }
        return url;
    }

    public String computeDocumentURL(DocumentModel doc) {
        DocumentLocationImpl docLoc = new DocumentLocationImpl(doc.getRepositoryName(), (DocumentRef)new IdRef(doc.getId()));
        DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc, ((TypeInfo)doc.getAdapter(TypeInfo.class)).getDefaultView());
        DocumentViewCodecManager documentViewCodecManager = (DocumentViewCodecManager)Framework.getLocalService(DocumentViewCodecManager.class);
        String documentLinkBuilder = (String)this.ctx.getProperty("documentLinkBuilder");
        String codecName = StringUtils.isBlank((String)documentLinkBuilder) ? documentViewCodecManager.getDefaultCodecName() : documentLinkBuilder;
        String baseURL = VirtualHostHelper.getBaseURL((ServletRequest)this.ctx.getRequest());
        return documentViewCodecManager.getUrlFromDocumentView(codecName, (DocumentView)docView, true, baseURL);
    }
}

