/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.gadgets;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;

@Operation(id="Social.Join", category="Execution Context", label="Join Social Workspace", description="Operation that will handle join request")
public class JoinSocialWorkspaceRequest {
    public static final String ID = "Social.Join";
    private static final Log log = LogFactory.getLog(JoinSocialWorkspaceRequest.class);
    @Context
    protected CoreSession session;
    @Context
    protected SocialWorkspaceService socialWorkspaceService;
    @Param(name="contextPath", required=true)
    protected String contextPath;

    @OperationMethod
    public void run() {
        if (StringUtils.isBlank((String)this.contextPath)) {
            return;
        }
        SocialWorkspace socialWorkspace = this.socialWorkspaceService.getDetachedSocialWorkspace(this.session, (DocumentRef)new PathRef(this.contextPath));
        socialWorkspace.handleSubscriptionRequest(this.session.getPrincipal());
    }
}

