/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.rest.RestHelper;
import org.nuxeo.ecm.social.workspace.SocialWorkspaceActions;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.ecm.webapp.helpers.EventManager;

@Name(value="collaborationActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class CollaborationActions
implements Serializable {
    private static final Log log = LogFactory.getLog(CollaborationActions.class);
    private static final String AFTER_SOCIAL_COLLABORATION_EDITION_VIEW = "after-social-collaboration-edition";
    private static final String AFTER_SOCIAL_COLLABORATION_CREATION_VIEW = "after-social-collaboration-creation";
    private static final String EDIT_SOCIAL_DOCUMENT_VIEW = "edit_social_document";
    private static final String CREATE_SOCIAL_DOCUMENT_VIEW = "create_social_document";
    private static final String DELETE_TRANSITION = "delete";
    private static final String NEWS_ITEMS_VIEW = "news_items";
    private static final String ARTICLES_VIEW = "articles";
    private static final String FILES_VIEW = "files";
    private static final long serialVersionUID = 1L;
    public static final String COLLABORATION_VIEW_ID = "collaboration";
    public static final String DASHBOARD_VIEW_ID = "dashboard";
    public static final String MAIN_TABS_DOCUMENTS = "MAIN_TABS:documents";
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient DocumentActions documentActions;
    @In(create=true)
    protected transient SocialWorkspaceActions socialWorkspaceActions;
    @In(create=true)
    protected transient SocialWorkspaceService socialWorkspaceService;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient RestHelper restHelper;
    protected DocumentModel previous;

    public DocumentModel getPrevious() {
        return this.previous;
    }

    public String backToDashboard() throws ClientException {
        SocialWorkspace socialWorkspace;
        DocumentModel currentDocument;
        DocumentModel sourceDocument = currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument.isProxy()) {
            sourceDocument = this.documentManager.getSourceDocument(currentDocument.getRef());
        }
        if ((socialWorkspace = this.socialWorkspaceService.getDetachedSocialWorkspace(sourceDocument)) != null) {
            DocumentModel dashboardSpacesRoot = this.documentManager.getDocument((DocumentRef)new PathRef(socialWorkspace.getDashboardSpacesRootPath()));
            this.webActions.setCurrentTabIds("MAIN_TABS:collab");
            return this.navigationContext.navigateToDocument(dashboardSpacesRoot, COLLABORATION_VIEW_ID);
        }
        return this.navigationContext.navigateToDocument(currentDocument);
    }

    public String getCurrentDashboardUrl() throws ClientException {
        DocumentModel dashboard;
        SocialWorkspace sw = this.socialWorkspaceActions.getSocialWorkspace();
        String view = DASHBOARD_VIEW_ID;
        if (sw == null) {
            dashboard = this.navigationContext.getCurrentDocument();
            view = "view_collaboration";
        } else {
            dashboard = this.documentManager.getDocument((DocumentRef)new PathRef(sw.getDashboardSpacesRootPath()));
        }
        return this.restHelper.getDocumentUrl(dashboard, view, false);
    }

    public String navigateToDMView() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if ("DashboardSpacesContainer".equals(currentDocument.getType())) {
            DocumentModel superSpace = this.documentManager.getSuperSpace(currentDocument);
            this.webActions.setCurrentTabIds(MAIN_TABS_DOCUMENTS);
            return this.navigationContext.navigateToDocument(superSpace);
        }
        return this.navigationContext.navigateToDocument(currentDocument);
    }

    public String navigateToCollaborationView() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (SocialWorkspaceHelper.isSocialWorkspace((DocumentModel)currentDocument)) {
            SocialWorkspace socialWorkspace = SocialWorkspaceHelper.toSocialWorkspace((DocumentModel)currentDocument);
            DocumentModel dashboardSpacesRoot = this.documentManager.getDocument((DocumentRef)new PathRef(socialWorkspace.getDashboardSpacesRootPath()));
            this.webActions.setCurrentTabIds("MAIN_TABS:collab");
            return this.navigationContext.navigateToDocument(dashboardSpacesRoot, COLLABORATION_VIEW_ID);
        }
        if (SocialWorkspaceHelper.isSocialDocument((DocumentModel)currentDocument)) {
            this.webActions.setCurrentTabIds("MAIN_TABS:collab");
            return this.navigationContext.navigateToDocument(currentDocument, COLLABORATION_VIEW_ID);
        }
        return this.navigationContext.navigateToDocument(currentDocument);
    }

    public String navigateToArticles() throws ClientException {
        return this.navigateToListing(ARTICLES_VIEW);
    }

    protected String navigateToListing(String listingView) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        SocialWorkspace socialWorkspace = this.socialWorkspaceService.getDetachedSocialWorkspace(currentDocument);
        if (socialWorkspace != null) {
            DocumentModel dashboardSpacesRoot = this.documentManager.getDocument((DocumentRef)new PathRef(socialWorkspace.getDashboardSpacesRootPath()));
            return this.navigationContext.navigateToDocument(dashboardSpacesRoot, listingView);
        }
        return this.navigationContext.navigateToDocument(currentDocument);
    }

    public String createNewDocument(String type) throws ClientException {
        DocumentModel parent = this.documentManager.getDocument(this.getParentDocumentRef(type));
        this.navigationContext.navigateToDocument(parent);
        this.documentActions.createDocument(type);
        return CREATE_SOCIAL_DOCUMENT_VIEW;
    }

    public DocumentModel getChangeableSocialDocument() throws ClientException {
        if (this.navigationContext.getChangeableDocument() == null) {
            this.createNewDocument("SocialWorkspace");
        }
        return this.navigationContext.getChangeableDocument();
    }

    protected DocumentRef getParentDocumentRef(String type) {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (SocialWorkspaceHelper.isSocialWorkspaceContainer((DocumentModel)currentDoc)) {
            return currentDoc.getRef();
        }
        SocialWorkspace socialWorkspace = this.socialWorkspaceActions.getSocialWorkspace();
        if ("NewsItem".equals(type)) {
            return new PathRef(socialWorkspace.getNewsItemsRootPath());
        }
        if ("SocialWorkspace".equals(type)) {
            return this.socialWorkspaceActions.getSocialWorkspaceContainer().getRef();
        }
        return socialWorkspace.getDocument().getRef();
    }

    public String createSameTypeDocument() throws ClientException {
        String type = this.navigationContext.getCurrentDocument().getType();
        return this.createNewDocument(type);
    }

    public void deleteSocialDocument(DocumentModel document) throws ClientException {
        document.followTransition(DELETE_TRANSITION);
        this.documentManager.saveDocument(document);
        DocumentModel parentDoc = this.documentManager.getDocument(document.getParentRef());
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{parentDoc});
    }

    public String navigateToNewsItems() throws ClientException {
        return this.navigateToListing(NEWS_ITEMS_VIEW);
    }

    public String editSocialDocument() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.editSocialDocument(currentDocument);
    }

    public String editSocialDocument(DocumentModel document) throws ClientException {
        if (SocialWorkspaceHelper.isSocialDocument((DocumentModel)document)) {
            return this.navigationContext.navigateToDocument(document, EDIT_SOCIAL_DOCUMENT_VIEW);
        }
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.navigationContext.navigateToDocument(currentDocument);
    }

    public String goBack() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument != null) {
            this.navigationContext.setChangeableDocument(null);
        } else {
            this.navigationContext.resetCurrentContext();
            EventManager.raiseEventsOnGoingHome();
        }
        return this.backToDashboard();
    }

    public String saveOncreate() throws ClientException {
        this.documentActions.saveDocument();
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.navigationContext.navigateToDocument(currentDoc, AFTER_SOCIAL_COLLABORATION_CREATION_VIEW);
    }

    public String updateCurrentDocument() throws ClientException {
        this.documentActions.updateCurrentDocument();
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.navigationContext.navigateToDocument(currentDocument, AFTER_SOCIAL_COLLABORATION_EDITION_VIEW);
    }

    public String displayCreateSocialWorkspaceForm() throws ClientException {
        this.previous = this.navigationContext.getCurrentDocument();
        if (this.previous != null && "DashboardSpacesContainer".equals(this.previous.getType()) && this.documentManager.hasPermission(this.previous.getParentRef(), "Read")) {
            this.previous = this.documentManager.getDocument(this.previous.getParentRef());
        }
        return this.createNewDocument("SocialWorkspace");
    }

    public String goToPreviousDocument() throws ClientException {
        if (this.previous != null) {
            this.navigationContext.setCurrentDocument(this.previous);
            this.previous = null;
            return this.navigateToCollaborationView();
        }
        return null;
    }

    public String getViewId() {
        return FacesContext.getCurrentInstance().getViewRoot().getViewId();
    }

    public boolean canCreateSocialWorkspace() {
        try {
            DocumentModel parent = this.socialWorkspaceService.getSocialWorkspaceContainer(this.documentManager);
            if (parent != null) {
                return this.documentManager.hasPermission(parent.getRef(), "AddChildren");
            }
        }
        catch (Exception e) {
            log.debug((Object)e, (Throwable)e);
        }
        return false;
    }

    public String navigateToFiles() throws ClientException {
        return this.navigateToListing(FILES_VIEW);
    }
}

