/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.user.relationship.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.social.relationship.RelationshipKind;
import org.nuxeo.ecm.social.relationship.service.RelationshipService;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;

public class UserRelationshipPageProvider
extends AbstractPageProvider<DocumentModel> {
    private static final Log log = LogFactory.getLog(UserRelationshipPageProvider.class);
    private static final long serialVersionUID = 1L;
    protected List<String> relationships;
    protected List<DocumentModel> relationshipPage;
    protected RelationshipService relationshipService;
    protected UserManager userManager;
    protected UserProfileService userProfileService;
    public static final String CORE_SESSION_PROPERTY = "coreSession";

    public List<DocumentModel> getCurrentPage() {
        block3: {
            long pageSize;
            block4: {
                if (this.relationships == null) {
                    this.fillRelationshipsForCurrentUser();
                }
                if (this.hasError()) break block3;
                this.relationshipPage = new DocumentModelListImpl();
                this.resultsCount = this.relationships.size();
                pageSize = this.getMinMaxPageSize();
                if (pageSize != 0L) break block4;
                for (String relationship : this.relationships) {
                    this.addUsernameToRelationshipPage(ActivityHelper.getUsername((String)relationship));
                }
                break block3;
            }
            if (this.offset > this.resultsCount) break block3;
            int i = Long.valueOf(this.offset).intValue();
            while ((long)i < this.resultsCount && (long)i < this.offset + pageSize) {
                this.addUsernameToRelationshipPage(ActivityHelper.getUsername((String)this.relationships.get(i)));
                ++i;
            }
        }
        return this.relationshipPage;
    }

    protected void addUsernameToRelationshipPage(String username) {
        try {
            DocumentModel userProfile = this.getUserProfileService().getUserProfile(this.getUserManager().getUserModel(username), this.getCoreSession());
            this.relationshipPage.add(userProfile);
        }
        catch (ClientException e) {
            log.warn((Object)("Cannot get user model for:" + username), (Throwable)e);
        }
    }

    protected void fillRelationshipsForCurrentUser() {
        this.relationships = new ArrayList<String>();
        this.relationships.addAll(this.getRelationshipService().getTargetsOfKind(this.getCurrentUser(), RelationshipKind.fromGroup((String)"circle")));
    }

    protected RelationshipService getRelationshipService() {
        if (this.relationshipService == null) {
            try {
                this.relationshipService = (RelationshipService)Framework.getService(RelationshipService.class);
            }
            catch (Exception e) {
                log.warn((Object)"Failed to get UserRelationshipService", (Throwable)e);
            }
        }
        return this.relationshipService;
    }

    protected UserManager getUserManager() {
        if (this.userManager == null) {
            try {
                this.userManager = (UserManager)Framework.getService(UserManager.class);
            }
            catch (Exception e) {
                log.warn((Object)"Failed to get UserManager", (Throwable)e);
            }
        }
        return this.userManager;
    }

    protected UserProfileService getUserProfileService() {
        if (this.userProfileService == null) {
            try {
                this.userProfileService = (UserProfileService)Framework.getService(UserProfileService.class);
            }
            catch (Exception e) {
                log.warn((Object)"Failed to get UserProfileService", (Throwable)e);
            }
        }
        return this.userProfileService;
    }

    protected String getCurrentUser() {
        Object[] params = this.getParameters();
        if (params.length >= 1) {
            return ActivityHelper.createUserActivityObject((String)((String)params[0]));
        }
        return null;
    }

    public void refresh() {
        super.refresh();
        this.relationships = null;
    }

    protected CoreSession getCoreSession() {
        Map props = this.getProperties();
        CoreSession coreSession = (CoreSession)props.get(CORE_SESSION_PROPERTY);
        if (coreSession == null) {
            throw new ClientRuntimeException("cannot find core session");
        }
        return coreSession;
    }
}

