/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.admin.management;

import java.net.URL;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.admin.management.ExtensionPointResource;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.view.TemplateView;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.ExtensionPoint;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.impl.DefaultRuntimeContext;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;

public class ComponentResource {
    protected RegistrationInfo ri;

    public ComponentResource(RegistrationInfo ri) {
        this.ri = ri;
    }

    @GET
    @Path(value="html")
    @Produces(value={"text/html"})
    public Object getHtml() {
        return new TemplateView((Object)this, "component.html.ftl").arg("component", (Object)this.ri);
    }

    @GET
    @Produces(value={"application/xml"})
    public URL doGet() {
        try {
            DefaultRuntimeContext rc = (DefaultRuntimeContext)this.ri.getContext();
            Map deployedFiles = rc.getDeployedFiles();
            String name = this.ri.getName().getName();
            if (deployedFiles != null) {
                for (Map.Entry entry : deployedFiles.entrySet()) {
                    if (!name.equals(((ComponentName)entry.getValue()).getName())) continue;
                    return new URL((String)entry.getKey());
                }
            }
            throw new WebResourceNotFoundException("Component definition not found for " + this.ri.getName().getName());
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    @Path(value="xpoints")
    @Produces(value={"application/atomsvc+xml"})
    public Object getExtensionPoints() {
        return new TemplateView((Object)this, "xpoints.ftl").arg("xpoints", (Object)this.ri.getExtensionPoints()).arg("ri", (Object)this.ri);
    }

    @GET
    @Path(value="contribs")
    @Produces(value={"application/atomsvc+xml"})
    public Object getContribs() {
        return new TemplateView((Object)this, "contribs.ftl").arg("contribs", (Object)this.ri.getExtensions()).arg("ri", (Object)this.ri);
    }

    @Path(value="xpoints/{xpoint}")
    public Object getExtensionPoint(@PathParam(value="xpoint") String xpoint) {
        for (ExtensionPoint xp : this.ri.getExtensionPoints()) {
            if (!xp.getName().equals(xpoint)) continue;
            return new ExtensionPointResource(this.ri, xp);
        }
        throw new WebResourceNotFoundException("No such extension point: " + xpoint);
    }

    @DELETE
    public Object removeComponent() {
        if (this.ri.isPersistent()) {
            try {
                ((OSGiRuntimeService)Framework.getRuntime()).getComponentPersistence().removeComponent(this.ri.getName().getName());
            }
            catch (Exception e) {
                throw WebException.wrap((String)"Failed to create component", (Throwable)e);
            }
        }
        return null;
    }

    @PUT
    public Object switchComponentState() {
        RegistrationInfoImpl rii = (RegistrationInfoImpl)this.ri;
        try {
            if (rii.isActivated()) {
                rii.deactivate();
            } else {
                rii.activate();
            }
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
        return null;
    }

    public String getSummary() throws Exception {
        return this.ri.getDocumentation();
    }
}

